/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.blobs.HierarchicalBlobManager;
import com.manydesigns.elements.blobs.SimpleBlobManager;
import com.manydesigns.portofino.code.CodeBase;
import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
public class PortofinoSpringConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PortofinoSpringConfiguration.class);
    public static final String PORTOFINO_CONFIGURATION = "portofinoConfiguration";
    public static final String ACTIONS_DIRECTORY = "actionsDirectory";
    public static final String APPLICATION_DIRECTORY = "applicationDirectory";
    public static final String DEFAULT_BLOB_MANAGER = "defaultBlobManager";
    protected ServletContext servletContext;
    protected ApplicationContext applicationContext;

    @Bean(name={"portofinoConfiguration"})
    public Configuration getPortofinoConfiguration() {
        return (Configuration)this.getServletContext().getAttribute(PORTOFINO_CONFIGURATION);
    }

    @Bean(name={"applicationDirectory"})
    public File getApplicationDirectory() {
        return (File)this.getServletContext().getAttribute("com.manydesigns.portofino.application.directory");
    }

    @Bean(name={"actionsDirectory"})
    public File getApplicationDirectory(@Autowired @Qualifier(value="portofinoConfiguration") Configuration configuration, @Autowired @Qualifier(value="applicationDirectory") File applicationDirectory) {
        String actionsDirectory = configuration.getString("portofino.actions.path", "actions");
        return new File(applicationDirectory, actionsDirectory);
    }

    @Bean
    public CodeBase getCodeBase() {
        return (CodeBase)this.getServletContext().getAttribute("portofino.codebase");
    }

    @Bean
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Autowired
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Bean(name={"defaultBlobManager"})
    public BlobManager getDefaultBlobManager(@Autowired @Qualifier(value="portofinoConfiguration") Configuration configuration, @Autowired @Qualifier(value="applicationDirectory") File applicationDirectory) {
        File appBlobsDir = configuration.containsKey("blobs.dir.path") ? new File(configuration.getString("blobs.dir.path")) : new File(applicationDirectory, "blobs");
        logger.info("Blobs directory: " + appBlobsDir.getAbsolutePath());
        String metaFilenamePattern = "blob-{0}.properties";
        String dataFilenamePattern = "blob-{0}.data";
        File[] blobs = appBlobsDir.listFiles((dir, name) -> name.startsWith("blob-") && name.endsWith(".properties"));
        if (blobs == null || blobs.length == 0) {
            logger.info("Using hierarchical blob manager");
            return new HierarchicalBlobManager(appBlobsDir, metaFilenamePattern, dataFilenamePattern);
        }
        logger.warn("Blobs found directly under the blobs directory; using old style (pre-4.1.1) flat file blob manager");
        return new SimpleBlobManager(appBlobsDir, metaFilenamePattern, dataFilenamePattern);
    }
}

