/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.spring.ConfigurationPropertySource;
import com.manydesigns.portofino.spring.PortofinoSpringConfiguration;
import java.lang.reflect.Modifier;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

@HandlesTypes(value={Module.class})
public class PortofinoSpringServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger logger = LoggerFactory.getLogger(PortofinoSpringServletContainerInitializer.class);
    protected ServletContext servletContext;
    protected final Set<Class<? extends Module>> moduleClasses = new HashSet<Class<? extends Module>>();

    public void onStartup(Set<Class<?>> moduleClasses, ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        for (Class<?> candidate : moduleClasses) {
            if (candidate.isInterface() || Modifier.isAbstract(candidate.getModifiers()) || !Module.class.isAssignableFrom(candidate)) continue;
            this.moduleClasses.add(candidate.asSubclass(Module.class));
        }
        this.registerContextLoaderListener(servletContext);
    }

    protected void registerContextLoaderListener(ServletContext servletContext) {
        WebApplicationContext rootAppContext = this.createRootApplicationContext();
        ContextLoaderListener listener = new ContextLoaderListener(rootAppContext);
        listener.setContextInitializers(this.getRootApplicationContextInitializers());
        servletContext.addListener((EventListener)listener);
    }

    protected WebApplicationContext createRootApplicationContext() {
        return new AnnotationConfigWebApplicationContext();
    }

    protected ApplicationContextInitializer<?>[] getRootApplicationContextInitializers() {
        return new ApplicationContextInitializer[]{applicationContext -> {
            ElementsThreadLocals.setupDefaultElementsContext();
            MutablePropertySources sources = applicationContext.getEnvironment().getPropertySources();
            Configuration configuration = (Configuration)this.servletContext.getAttribute("portofinoConfiguration");
            sources.addFirst((PropertySource)new ConfigurationPropertySource("portofino.properties", configuration));
            AnnotationConfigRegistry annotationConfig = (AnnotationConfigRegistry)applicationContext;
            for (Class<? extends Module> moduleClass : this.moduleClasses) {
                annotationConfig.register(new Class[]{moduleClass});
            }
            annotationConfig.register(new Class[]{PortofinoSpringConfiguration.class});
            CodeBase codeBase = (CodeBase)this.servletContext.getAttribute("portofino.codebase");
            ((DefaultResourceLoader)applicationContext).setClassLoader(codeBase.asClassLoader());
            try {
                annotationConfig.register(new Class[]{codeBase.loadClass("SpringConfiguration")});
            }
            catch (Exception e) {
                logger.info("User-defined Spring configuration not found", (Throwable)e);
            }
        }};
    }
}

