/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.PortofinoProperties;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;

public class BaseModule
implements Module {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(BaseModule.class);
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final String PORTOFINO_CONFIGURATION = "portofinoConfiguration";
    public static final String APPLICATION_DIRECTORY = "com.manydesigns.portofino.application.directory";
    public static final String RESOURCE_BUNDLE_MANAGER = "com.manydesigns.portofino.resourceBundleManager";
    public static final String SERVER_INFO = "com.manydesigns.portofino.serverInfo";
    @Autowired
    public Configuration configuration;
    @Autowired
    public ServletContext servletContext;

    @Override
    public String getModuleVersion() {
        return PortofinoProperties.getPortofinoVersion();
    }

    @Override
    public String getName() {
        return "Base";
    }

    @Bean
    public CacheResetListenerRegistry getCacheResetListenerRegistry() {
        return new CacheResetListenerRegistry();
    }

    @PostConstruct
    public void init() {
        this.status = ModuleStatus.STARTED;
    }

    @PreDestroy
    public void destroy() {
        this.status = ModuleStatus.DESTROYED;
    }

    @Override
    public ModuleStatus getStatus() {
        return this.status;
    }
}

