/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.messages.RequestMessages;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.util.ReflectionUtil;
import com.manydesigns.portofino.actions.ActionDescriptor;
import com.manydesigns.portofino.actions.ActionLogic;
import com.manydesigns.portofino.actions.Group;
import com.manydesigns.portofino.actions.Permissions;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.dispatcher.AbstractResourceWithParameters;
import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.operations.GuardType;
import com.manydesigns.portofino.operations.Operation;
import com.manydesigns.portofino.operations.Operations;
import com.manydesigns.portofino.resourceactions.ActionContext;
import com.manydesigns.portofino.resourceactions.ActionInstance;
import com.manydesigns.portofino.resourceactions.ActionNotActiveException;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionLogic;
import com.manydesigns.portofino.resourceactions.registry.ActionRegistry;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.security.RequiresAdministrator;
import com.manydesigns.portofino.security.RequiresPermissions;
import com.manydesigns.portofino.security.SecurityLogic;
import com.manydesigns.portofino.security.SupportsPermissions;
import com.manydesigns.portofino.shiro.ShiroUtils;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.json.JSONStringer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RequiresPermissions(level=AccessLevel.VIEW)
public abstract class AbstractResourceAction
extends AbstractResourceWithParameters
implements ResourceAction {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public ActionInstance actionInstance;
    @Autowired
    public Configuration portofinoConfiguration;
    @Autowired
    protected CodeBase codeBase;
    @Autowired
    protected ActionRegistry actionRegistry;
    @Context
    protected UriInfo uriInfo;
    protected ActionContext context;
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceAction.class);

    protected AbstractResourceAction() {
        this.maxParameters = ResourceActionLogic.supportsDetail(this.getClass()) ? Integer.MAX_VALUE : 0;
    }

    protected void initSubResource(Resource resource) {
        super.initSubResource(resource);
        if (resource instanceof ResourceAction) {
            AbstractResourceAction.initResourceAction((ResourceAction)resource, this.getActionInstance(), this.uriInfo);
        }
    }

    public static void initResourceAction(ResourceAction resourceAction, ActionInstance parentActionInstance, UriInfo uriInfo) {
        ActionDescriptor action;
        HttpServletRequest request = ElementsThreadLocals.getHttpServletRequest();
        HttpServletResponse response = ElementsThreadLocals.getHttpServletResponse();
        try {
            action = ActionLogic.getActionDescriptor(resourceAction.getLocation());
        }
        catch (ActionNotActiveException e) {
            logger.debug("action.xml not found or not valid", (Throwable)e);
            action = new ActionDescriptor();
            action.init();
        }
        ActionInstance actionInstance = new ActionInstance(parentActionInstance, resourceAction.getLocation(), action, resourceAction.getClass());
        actionInstance.setActionBean(resourceAction);
        ActionLogic.configureResourceAction(resourceAction, actionInstance);
        ActionContext context = new ActionContext();
        context.setRequest(request);
        context.setResponse(response);
        context.setServletContext(request.getServletContext());
        if (uriInfo != null) {
            String path = uriInfo.getPath();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            context.setActionPath(path);
        }
        resourceAction.setContext(context);
    }

    @Override
    public void prepareForExecution() {
    }

    public void consumeParameter(String pathSegment) {
        super.consumeParameter(pathSegment);
        this.actionInstance.getParameters().add(pathSegment);
    }

    public FileObject getChildrenLocation() throws FileSystemException {
        if (this.parameters.isEmpty()) {
            return this.getLocation();
        }
        return this.getLocation().resolveFile("_detail");
    }

    @Override
    public ResourceAction getParent() {
        return (ResourceAction)super.getParent();
    }

    public String getActionPath() {
        return this.context.getActionPath();
    }

    public String getApiRootUri() {
        ServletContext servletContext = this.getContext().getServletContext();
        String apiRoot = servletContext.getInitParameter("portofino.api.root");
        if (apiRoot == null) {
            apiRoot = "http://localhost:8080";
        } else if (!apiRoot.contains("://") && !apiRoot.startsWith("/")) {
            apiRoot = servletContext.getContextPath() + "/" + apiRoot;
        }
        if (!apiRoot.contains("://")) {
            URI baseUri = this.uriInfo.getBaseUri();
            apiRoot = baseUri.getScheme() + "://" + baseUri.getAuthority() + apiRoot;
        }
        if (!apiRoot.endsWith("/")) {
            apiRoot = apiRoot + "/";
        }
        return apiRoot;
    }

    public String getAbsoluteActionPath() {
        return this.getApiRootUri() + this.getActionPath();
    }

    @Override
    public ActionInstance getActionInstance() {
        return this.actionInstance;
    }

    @Override
    public void setActionInstance(ActionInstance actionInstance) {
        this.actionInstance = actionInstance;
    }

    public ActionDescriptor getActionDescriptor() {
        return this.getActionInstance().getActionDescriptor();
    }

    public Map getOgnlContext() {
        return ElementsThreadLocals.getOgnlContext();
    }

    public Configuration getPortofinoConfiguration() {
        return this.portofinoConfiguration;
    }

    @Override
    public void setContext(ActionContext context) {
        this.context = context;
    }

    @Override
    public ActionContext getContext() {
        return this.context;
    }

    public Response resourceActionNotConfigured() {
        return Response.serverError().entity((Object)"resource-action-not-configured").build();
    }

    @io.swagger.v3.oas.annotations.Operation(operationId="com.manydesigns.portofino.resourceactions.AbstractResourceAction#describeOperations", description="Returns the list of operations that can be invoked via REST on this resource. If the user doesn't have permission to invoke an operation, or a VISIBLE guard doesn't pass, then the operation is excluded from the result. If an ENABLED guard doesn't pass, the operation is included, but it is marked as not available.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A list of operations (name, signature, available).")})
    @Path(value=":operations")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public List describeOperations() {
        HttpServletRequest request = this.context.getRequest();
        List<Operation> operations = Operations.getOperations(this.getClass());
        ArrayList result = new ArrayList();
        Subject subject = SecurityUtils.getSubject();
        for (Operation operation : operations) {
            boolean visible;
            logger.trace("Operation: {}", (Object)operation);
            Method handler = operation.getMethod();
            boolean isAdmin = SecurityLogic.isAdministrator((ServletRequest)request);
            if (!isAdmin && (this.actionInstance != null && !SecurityLogic.hasPermissions(this.portofinoConfiguration, operation.getMethod(), this.getClass(), this.actionInstance, subject) || !SecurityLogic.satisfiesRequiresAdministrator(request, this, handler)) || !(visible = Operations.doGuardsPass(this, handler, GuardType.VISIBLE))) continue;
            boolean available = Operations.doGuardsPass(this, handler, GuardType.ENABLED);
            HashMap<String, Object> operationInfo = new HashMap<String, Object>();
            operationInfo.put("name", operation.getName());
            operationInfo.put("signature", operation.getSignature());
            operationInfo.put("available", available);
            result.add(operationInfo);
        }
        return result;
    }

    protected void describe(Map<String, Object> description) {
        super.describe(description);
        description.put("page", this.actionInstance.getActionDescriptor());
        if (ResourceActionLogic.supportsDetail(this.getClass())) {
            this.parameters.add("");
            description.put("detailChildren", this.getSubResources());
            this.parameters.remove(this.parameters.size() - 1);
        }
    }

    @io.swagger.v3.oas.annotations.Operation(operationId="com.manydesigns.portofino.resourceactions.AbstractResourceAction#getConfiguration", description="Returns the configuration of this action. The actual type of the configuration object depends on the action class.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The configuration object.")})
    @Path(value=":configuration")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Object getConfiguration() {
        return this.actionInstance.getConfiguration();
    }

    @io.swagger.v3.oas.annotations.Operation(operationId="com.manydesigns.portofino.resourceactions.AbstractResourceAction#setConfiguration", description="Update the configuration of this action. The actual type of the configuration object depends on the action class.")
    @RequiresAdministrator
    @PUT
    @Path(value=":configuration")
    public void setConfiguration(@RequestBody(description="The configuration object in JSON format.") String configurationString) throws IOException {
        Class<?> configurationClass = ResourceActionLogic.getConfigurationClass(this.getClass());
        Object configuration = new ObjectMapper().readValue(configurationString, configurationClass);
        this.saveConfiguration(configuration);
    }

    protected boolean saveConfiguration(Object configuration) {
        try {
            FileObject confFile = ActionLogic.saveConfiguration(this.actionInstance.getDirectory(), configuration);
            logger.info("Configuration saved to " + confFile.getName().getPath());
            return true;
        }
        catch (Exception e) {
            logger.error("Couldn't save configuration", (Throwable)e);
            RequestMessages.addErrorMessage((String)"error saving conf");
            return false;
        }
    }

    @io.swagger.v3.oas.annotations.Operation(operationId="com.manydesigns.portofino.resourceactions.AbstractResourceAction#getConfigurationAccessor", description="A ClassAccessor that describes the configuration of this action.")
    @GET
    @Path(value=":configuration/classAccessor")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getConfigurationAccessor() {
        Class<?> configurationClass = ResourceActionLogic.getConfigurationClass(this.getClass());
        if (configurationClass == null) {
            return null;
        }
        JavaClassAccessor classAccessor = JavaClassAccessor.getClassAccessor(configurationClass);
        JSONStringer jsonStringer = new JSONStringer();
        ReflectionUtil.classAccessorToJson((ClassAccessor)classAccessor, (JSONStringer)jsonStringer);
        return jsonStringer.toString();
    }

    @io.swagger.v3.oas.annotations.Operation(operationId="com.manydesigns.portofino.resourceactions.AbstractResourceAction#getActionPermissions", description="An object describing the permissions on this resource; both currently active permissions and supported values.")
    @GET
    @Path(value=":permissions")
    @Produces(value={"application/json;charset=UTF-8"})
    public Map<String, Object> getActionPermissions() {
        ArrayList<Group> allGroups = new ArrayList<Group>(this.getActionDescriptor().getPermissions().getGroups());
        Set<String> possibleGroups = ShiroUtils.getPortofinoRealm().getGroups();
        for (String group : possibleGroups) {
            if (!allGroups.stream().noneMatch(g -> group.equals(g.getName()))) continue;
            Group emptyGroup = new Group();
            emptyGroup.setName(group);
            allGroups.add(emptyGroup);
        }
        ActionInstance parentActionInstance = this.getActionInstance().getParent();
        allGroups.forEach(g -> {
            if (g.getAccessLevel() == null && parentActionInstance != null) {
                Permissions parentPermissions = SecurityLogic.calculateActualPermissions(parentActionInstance);
                g.setActualAccessLevel(parentPermissions.getActualLevels().get(g.getName()));
            }
        });
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("groups", allGroups);
        result.put("permissions", this.getSupportedPermissions());
        return result;
    }

    @io.swagger.v3.oas.annotations.Operation(operationId="com.manydesigns.portofino.resourceactions.AbstractResourceAction#setActionPermissions", description="Set the permissions about this resource.")
    @RequiresAdministrator
    @PUT
    @Path(value=":permissions")
    @Consumes(value={"application/json;charset=UTF-8"})
    public void setActionPermissions(@RequestBody(description="An array of permissions, one for each user group. Each element of the array has a group name, a desired access level (null means inherited) and a list of action-specific permissions.") List<Group> groups) throws Exception {
        List<Group> existingGroups = this.getActionDescriptor().getPermissions().getGroups();
        existingGroups.clear();
        existingGroups.addAll(groups);
        FileObject saved = ActionLogic.saveActionDescriptor(this.actionInstance);
        logger.info("Saved permissions to " + saved.getName().getPath());
    }

    public String[] getSupportedPermissions() {
        Class<? extends ResourceAction> actualActionClass = this.getActionInstance().getActionClass();
        SupportsPermissions supportsPermissions = actualActionClass.getAnnotation(SupportsPermissions.class);
        while (supportsPermissions == null && actualActionClass.getSuperclass() != Object.class) {
            actualActionClass = actualActionClass.getSuperclass();
            supportsPermissions = actualActionClass.getAnnotation(SupportsPermissions.class);
        }
        if (supportsPermissions != null && supportsPermissions.value().length > 0) {
            return supportsPermissions.value();
        }
        return new String[0];
    }
}

