/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.security;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.actions.ActionDescriptor;
import com.manydesigns.portofino.actions.Permissions;
import com.manydesigns.portofino.resourceactions.ActionInstance;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.security.RequiresAdministrator;
import com.manydesigns.portofino.security.RequiresPermissions;
import com.manydesigns.portofino.shiro.ActionPermission;
import com.manydesigns.portofino.shiro.GroupPermission;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityLogic {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final String GROUP_ALL = "group.all";
    public static final String GROUP_ANONYMOUS = "group.anonymous";
    public static final String GROUP_REGISTERED = "group.registered";
    public static final String GROUP_ADMINISTRATORS = "group.administrators";
    public static final String GROUP_ALL_DEFAULT = "all";
    public static final String GROUP_ANONYMOUS_DEFAULT = "anonymous";
    public static final String GROUP_REGISTERED_DEFAULT = "registered";
    public static final String GROUP_ADMINISTRATORS_DEFAULT = "administrators";
    public static final Logger logger = LoggerFactory.getLogger(SecurityLogic.class);

    public static boolean hasPermissions(Configuration conf, ActionInstance instance, Subject subject, Method handler) {
        logger.debug("Checking action permissions");
        Class<? extends ResourceAction> theClass = instance.getActionClass();
        RequiresPermissions requiresPermissions = SecurityLogic.getRequiresPermissionsAnnotation(handler, theClass);
        if (requiresPermissions != null) {
            AccessLevel accessLevel = requiresPermissions.level();
            String[] permissions = requiresPermissions.permissions();
            return SecurityLogic.hasPermissions(conf, instance, subject, accessLevel, permissions);
        }
        return true;
    }

    public static boolean hasPermissions(Configuration conf, ActionInstance instance, Subject subject, AccessLevel accessLevel, String ... permissions) {
        Permissions configuration = SecurityLogic.calculateActualPermissions(instance);
        return SecurityLogic.hasPermissions(conf, configuration, subject, accessLevel, permissions);
    }

    public static Permissions calculateActualPermissions(ActionInstance instance) {
        ArrayList<ActionDescriptor> actionDescriptors = new ArrayList<ActionDescriptor>();
        while (instance != null) {
            actionDescriptors.add(0, instance.getActionDescriptor());
            instance = instance.getParent();
        }
        return SecurityLogic.calculateActualPermissions(new Permissions(), actionDescriptors);
    }

    public static Permissions calculateActualPermissions(Permissions basePermissions, List<ActionDescriptor> actionDescriptors) {
        Permissions result = new Permissions();
        Map<String, AccessLevel> resultLevels = result.getActualLevels();
        resultLevels.putAll(basePermissions.getActualLevels());
        for (ActionDescriptor current : actionDescriptors) {
            Permissions currentPerms = current.getPermissions();
            Map<String, AccessLevel> currentLevels = currentPerms.getActualLevels();
            for (Map.Entry<String, AccessLevel> entry : currentLevels.entrySet()) {
                String currentGroup = entry.getKey();
                AccessLevel currentLevel = entry.getValue();
                AccessLevel resultLevel = resultLevels.get(currentGroup);
                if (resultLevel == AccessLevel.DENY || currentLevel == null) continue;
                resultLevels.put(currentGroup, currentLevel);
            }
        }
        if (actionDescriptors.size() > 0) {
            ActionDescriptor lastAction = actionDescriptors.get(actionDescriptors.size() - 1);
            Map<String, Set<String>> lastPermissions = lastAction.getPermissions().getActualPermissions();
            result.getActualPermissions().putAll(lastPermissions);
        } else {
            result.getActualPermissions().putAll(basePermissions.getActualPermissions());
        }
        return result;
    }

    public static boolean hasPermissions(Configuration conf, Permissions configuration, Subject subject, Method handler, Class<?> theClass) {
        logger.debug("Checking action permissions");
        RequiresPermissions requiresPermissions = SecurityLogic.getRequiresPermissionsAnnotation(handler, theClass);
        if (requiresPermissions != null) {
            return SecurityLogic.hasPermissions(conf, configuration, subject, requiresPermissions);
        }
        return true;
    }

    public static boolean hasPermissions(Configuration conf, Permissions configuration, Subject subject, RequiresPermissions thing) {
        return SecurityLogic.hasPermissions(conf, configuration, subject, thing.level(), thing.permissions());
    }

    public static RequiresPermissions getRequiresPermissionsAnnotation(Method handler, Class<?> theClass) {
        RequiresPermissions requiresPermissions = handler.getAnnotation(RequiresPermissions.class);
        if (requiresPermissions != null) {
            logger.debug("Action method requires specific permissions: {}", (Object)handler);
        } else {
            requiresPermissions = theClass.getAnnotation(RequiresPermissions.class);
            if (requiresPermissions != null) {
                logger.debug("Action class requires specific permissions: {}", theClass);
            }
        }
        return requiresPermissions;
    }

    public static boolean hasPermissions(Configuration conf, Permissions configuration, Subject subject, AccessLevel level, String ... permissions) {
        Object principal = subject.getPrincipal();
        if (principal != null) {
            if (SecurityLogic.isAdministrator(conf)) {
                return true;
            }
            ActionPermission actionPermission = new ActionPermission(configuration, level, permissions);
            return subject.isPermitted((Permission)actionPermission);
        }
        return SecurityLogic.hasAnonymousPermissions(conf, configuration, level, permissions);
    }

    public static boolean hasPermissions(Configuration conf, Permissions configuration, SecurityManager securityManager, PrincipalCollection principals, AccessLevel level, String ... permissions) {
        if (principals != null) {
            ActionPermission actionPermission = new ActionPermission(configuration, level, permissions);
            return securityManager.isPermitted(principals, (Permission)actionPermission);
        }
        return SecurityLogic.hasAnonymousPermissions(conf, configuration, level, permissions);
    }

    public static boolean hasAnonymousPermissions(Configuration conf, Permissions configuration, AccessLevel level, String ... permissions) {
        ActionPermission actionPermission = new ActionPermission(configuration, level, permissions);
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(SecurityLogic.getAllGroup(conf));
        groups.add(SecurityLogic.getAnonymousGroup(conf));
        return new GroupPermission(groups).implies(actionPermission);
    }

    public static boolean isAdministrator(ServletRequest request) {
        ServletContext servletContext = ElementsThreadLocals.getServletContext();
        Configuration conf = (Configuration)servletContext.getAttribute("portofinoConfiguration");
        return SecurityLogic.isAdministrator(conf);
    }

    public static boolean isAdministrator(Configuration conf) {
        String administratorsGroup = SecurityLogic.getAdministratorsGroup(conf);
        Subject subject = SecurityUtils.getSubject();
        return subject.isAuthenticated() && subject.hasRole(administratorsGroup);
    }

    public static boolean satisfiesRequiresAdministrator(HttpServletRequest request, Object actionBean, Method handler) {
        boolean doesNotSatisfy;
        logger.debug("Checking if action or method required administrator");
        boolean requiresAdministrator = false;
        if (handler.isAnnotationPresent(RequiresAdministrator.class)) {
            logger.debug("Action method requires administrator: {}", (Object)handler);
            requiresAdministrator = true;
        } else {
            for (Class<?> actionClass = actionBean.getClass(); actionClass != null; actionClass = actionClass.getSuperclass()) {
                if (!actionClass.isAnnotationPresent(RequiresAdministrator.class)) continue;
                logger.debug("Action class requires administrator: {}", actionClass);
                requiresAdministrator = true;
                break;
            }
        }
        boolean isNotAdmin = !SecurityLogic.isAdministrator((ServletRequest)request);
        boolean bl = doesNotSatisfy = requiresAdministrator && isNotAdmin;
        if (doesNotSatisfy) {
            logger.debug("User is not an administrator");
            return false;
        }
        return true;
    }

    public static String getAdministratorsGroup(Configuration conf) {
        return conf.getString(GROUP_ADMINISTRATORS, GROUP_ADMINISTRATORS_DEFAULT);
    }

    public static String getAllGroup(Configuration conf) {
        return conf.getString(GROUP_ALL, GROUP_ALL_DEFAULT);
    }

    public static String getAnonymousGroup(Configuration conf) {
        return conf.getString(GROUP_ANONYMOUS, GROUP_ANONYMOUS_DEFAULT);
    }

    public static String getRegisteredGroup(Configuration conf) {
        return conf.getString(GROUP_REGISTERED, GROUP_REGISTERED_DEFAULT);
    }

    public static boolean isAllowed(HttpServletRequest request, ActionInstance actionInstance, Object actionBean, Method handler) {
        boolean isNotAdmin;
        Subject subject = SecurityUtils.getSubject();
        if (!SecurityLogic.satisfiesRequiresAdministrator(request, actionBean, handler)) {
            return false;
        }
        logger.debug("Checking actionDescriptor permissions");
        boolean bl = isNotAdmin = !SecurityLogic.isAdministrator((ServletRequest)request);
        if (isNotAdmin) {
            boolean allowed;
            String resource;
            ServletContext servletContext = request.getServletContext();
            Configuration configuration = (Configuration)servletContext.getAttribute("portofinoConfiguration");
            if (actionInstance != null) {
                logger.debug("The protected resource is a actionDescriptor action");
                resource = actionInstance.getPath();
                allowed = SecurityLogic.hasPermissions(configuration, actionInstance, subject, handler);
            } else {
                logger.debug("The protected resource is a regular JAX-RS resource");
                resource = request.getRequestURI();
                Permissions permissions = new Permissions();
                allowed = SecurityLogic.hasPermissions(configuration, permissions, subject, handler, actionBean.getClass());
            }
            if (!allowed) {
                logger.info("Access to {} is forbidden", (Object)resource);
                return false;
            }
        }
        return true;
    }

    public static boolean hasPermissions(Configuration conf, Method method, Class fallbackClass, ActionInstance actionInstance, Subject subject) {
        RequiresPermissions requiresPermissions = SecurityLogic.getRequiresPermissionsAnnotation(method, fallbackClass);
        if (requiresPermissions != null) {
            Permissions permissions = SecurityLogic.calculateActualPermissions(actionInstance);
            return SecurityLogic.hasPermissions(conf, permissions, subject, requiresPermissions);
        }
        return true;
    }
}

