/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.spring.ConfigurationPropertySource;
import com.manydesigns.portofino.spring.PortofinoSpringConfiguration;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.Modifier;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.apache.commons.configuration.Configuration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

@HandlesTypes(value={Module.class})
public class PortofinoSpringServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger logger = LoggerFactory.getLogger(PortofinoSpringServletContainerInitializer.class);
    public static final String RELOAD_CONTEXT_WHEN_SOURCES_CHANGE = "reloadContextWhenSourcesChange";
    protected ServletContext servletContext;
    protected final Set<Class<? extends Module>> moduleClasses = new HashSet<Class<? extends Module>>();
    protected final AtomicBoolean refreshing = new AtomicBoolean(false);

    public void onStartup(Set<Class<?>> moduleClasses, ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        for (Class<?> candidate : moduleClasses) {
            if (candidate.isInterface() || Modifier.isAbstract(candidate.getModifiers()) || !Module.class.isAssignableFrom(candidate)) continue;
            this.moduleClasses.add(candidate.asSubclass(Module.class));
        }
        this.registerContextLoaderListener(servletContext);
    }

    protected void registerContextLoaderListener(final ServletContext servletContext) {
        ContextLoaderListener listener = new ContextLoaderListener(){

            protected WebApplicationContext createWebApplicationContext(@NotNull ServletContext sc) {
                ConfigurableWebApplicationContext parentContext = PortofinoSpringServletContainerInitializer.this.createParentApplicationContext();
                ConfigurableWebApplicationContext rootContext = PortofinoSpringServletContainerInitializer.this.createRootApplicationContext();
                rootContext.setParent((ApplicationContext)parentContext);
                rootContext.addApplicationListener(event -> {
                    if (event instanceof ContextClosedEvent) {
                        parentContext.close();
                    }
                });
                CodeBase codeBase = (CodeBase)servletContext.getAttribute("portofino.codebase");
                try {
                    Class userConfigurationClass = codeBase.loadClass("SpringConfiguration");
                    ((DefaultResourceLoader)rootContext).setClassLoader(codeBase.asClassLoader());
                    ((AnnotationConfigRegistry)rootContext).register(new Class[]{userConfigurationClass});
                    boolean reload = !"false".equalsIgnoreCase(sc.getInitParameter(PortofinoSpringServletContainerInitializer.RELOAD_CONTEXT_WHEN_SOURCES_CHANGE));
                    Disposable subscription = codeBase.getReloads().subscribe(c -> {
                        if (reload && PortofinoSpringServletContainerInitializer.this.isReloadable((Class)c) && PortofinoSpringServletContainerInitializer.this.refreshing.compareAndSet(false, true)) {
                            logger.info("Detected reload of " + c + ", refreshing the application context");
                            PortofinoSpringServletContainerInitializer.refresh((ConfigurableApplicationContext)rootContext, codeBase);
                            PortofinoSpringServletContainerInitializer.this.refreshing.set(false);
                        }
                    });
                    rootContext.addApplicationListener(event -> {
                        if (event instanceof ContextClosedEvent) {
                            subscription.dispose();
                        }
                    });
                }
                catch (Exception e) {
                    logger.info("User-defined Spring configuration not found");
                    logger.debug("Additional info", (Throwable)e);
                }
                return rootContext;
            }

            protected void customizeContext(@NotNull ServletContext sc, ConfigurableWebApplicationContext wac) {
                ElementsThreadLocals.setupDefaultElementsContext();
                ConfigurableWebApplicationContext parent = (ConfigurableWebApplicationContext)wac.getParent();
                assert (parent != null);
                parent.setServletContext(sc);
                ConfigurableEnvironment environment = parent.getEnvironment();
                MutablePropertySources sources = environment.getPropertySources();
                Configuration configuration = (Configuration)servletContext.getAttribute("portofinoConfiguration");
                sources.addFirst((PropertySource)new ConfigurationPropertySource("portofino.properties", configuration));
                AnnotationConfigRegistry annotationConfig = (AnnotationConfigRegistry)parent;
                for (Class<? extends Module> moduleClass : PortofinoSpringServletContainerInitializer.this.moduleClasses) {
                    annotationConfig.register(new Class[]{moduleClass});
                }
                annotationConfig.register(new Class[]{PortofinoSpringConfiguration.class});
                parent.refresh();
                super.customizeContext(sc, wac);
            }
        };
        listener.setContextInitializers(this.getRootApplicationContextInitializers());
        servletContext.addListener((EventListener)listener);
    }

    protected boolean isReloadable(Class c) {
        return c.getAnnotation(Component.class) != null || c.getAnnotation(Repository.class) != null || c.getAnnotation(Service.class) != null;
    }

    public static void refresh(ConfigurableApplicationContext applicationContext, CodeBase codeBase) {
        ((DefaultResourceLoader)applicationContext).setClassLoader(codeBase.asClassLoader());
        applicationContext.refresh();
    }

    protected ConfigurableWebApplicationContext createParentApplicationContext() {
        return new AnnotationConfigWebApplicationContext();
    }

    protected ConfigurableWebApplicationContext createRootApplicationContext() {
        return new AnnotationConfigWebApplicationContext();
    }

    protected ApplicationContextInitializer<?>[] getRootApplicationContextInitializers() {
        return new ApplicationContextInitializer[0];
    }
}

