/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.quartz;

import com.manydesigns.mail.quartz.URLInvokeJob;
import com.manydesigns.mail.setup.MailQueueSetup;
import org.apache.commons.configuration.Configuration;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailScheduler {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(MailScheduler.class);
    public static final int DEFAULT_POLL_INTERVAL = 1000;

    public static void setupMailScheduler(MailQueueSetup mailQueueSetup) {
        String group = "portofino-mail";
        MailScheduler.setupMailScheduler(mailQueueSetup, group);
    }

    public static void setupMailScheduler(MailQueueSetup mailQueueSetup, String group) {
        Configuration mailConfiguration = mailQueueSetup.getMailConfiguration();
        if (mailConfiguration != null) {
            if (mailConfiguration.getBoolean("mail.quartz.enabled", false)) {
                logger.info("Scheduling mail sends with Quartz job");
                try {
                    String serverUrl = mailConfiguration.getString("mail.sender.server_url");
                    logger.info("Scheduling mail sends using URL: {}", (Object)serverUrl);
                    Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
                    JobDetail job = JobBuilder.newJob(URLInvokeJob.class).withIdentity("mail.sender", group).usingJobData("url", serverUrl).build();
                    int pollInterval = mailConfiguration.getInt("mail.sender.poll.interval", 1000);
                    Trigger trigger = TriggerBuilder.newTrigger().withIdentity("mail.sender.trigger", group).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)pollInterval).repeatForever()).build();
                    scheduler.scheduleJob(job, trigger);
                }
                catch (Exception e) {
                    logger.error("Could not schedule mail sender job", (Throwable)e);
                }
            } else {
                logger.info("Mail scheduling using Quartz is disabled");
            }
        }
    }
}

