/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.quartz;

import com.manydesigns.mail.sender.MailSender;
import java.util.HashSet;
import org.apache.commons.configuration.Configuration;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MailSenderJob
implements Job {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final String MAIL_SENDER_KEY = "mail.sender";
    public static final String MAIL_IDS_TO_MARK_AS_SENT = "mail.sender.idsToMarkAsSent";
    public static final Logger logger = LoggerFactory.getLogger(MailSenderJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        MailSender sender;
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        try {
            sender = (MailSender)jobExecutionContext.getScheduler().getContext().get((Object)MAIL_SENDER_KEY);
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        if (sender != null) {
            int serverErrors;
            HashSet idsToMarkAsSent = (HashSet)jobDataMap.get((Object)MAIL_IDS_TO_MARK_AS_SENT);
            if (idsToMarkAsSent == null) {
                idsToMarkAsSent = new HashSet();
            }
            if ((serverErrors = sender.runOnce(idsToMarkAsSent)) < 0) {
                logger.warn("Mail sender did not run.");
            } else if (serverErrors > 0) {
                logger.warn("Mail sender encountered {} server errors.", (Object)serverErrors);
            }
            jobDataMap.put(MAIL_IDS_TO_MARK_AS_SENT, idsToMarkAsSent);
        }
    }

    public static void schedule(MailSender mailSender, Configuration mailConfiguration, String group) throws SchedulerException {
        Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
        JobDetail job = JobBuilder.newJob(MailSenderJob.class).withIdentity(MAIL_SENDER_KEY, group).build();
        int pollInterval = mailConfiguration.getInt("mail.sender.poll.interval", 1000);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("mail.sender.trigger", group).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)pollInterval).repeatForever()).build();
        scheduler.getContext().put(MAIL_SENDER_KEY, (Object)mailSender);
        scheduler.scheduleJob(job, trigger);
    }
}

