/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.dispatcher.swagger.DocumentedApiRoot;
import com.manydesigns.portofino.dispatcher.web.ApplicationRoot;
import com.manydesigns.portofino.rest.PortofinoModelResolver;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Path(value="/")
public class PortofinoApplicationRoot
extends ApplicationRoot {
    @Context
    protected ServletConfig config;
    @Context
    protected Application application;

    @PostConstruct
    public void init() {
        try {
            new JaxrsOpenApiContextBuilder().servletConfig(this.config).application(this.application).resourceClasses(Collections.singleton(((Object)((Object)this)).getClass().getName())).buildContext(true);
        }
        catch (OpenApiConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected ResourceContext getResourceContext() {
        ServletContext servletContext = ElementsThreadLocals.getServletContext();
        final WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return new DocumentedApiRoot.DummyResourceContext(){

            public <T> T initResource(T resource) {
                super.initResource(resource);
                applicationContext.getAutowireCapableBeanFactory().autowireBean(resource);
                return resource;
            }
        };
    }

    public void beforeScan(Reader reader, OpenAPI openAPI) {
        super.beforeScan(reader, openAPI);
        ModelConverters.getInstance().addConverter((ModelConverter)new PortofinoModelResolver(Json.mapper()));
    }

    public void afterScan(Reader reader, OpenAPI openAPI) {
        super.afterScan(reader, openAPI);
    }
}

