/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.sender;

import com.manydesigns.mail.sender.MailSender;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSenderRunnable
implements Runnable {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected final MailSender sender;
    protected boolean alive;
    protected long pollInterval = 1000L;
    public static final Logger logger = LoggerFactory.getLogger(MailSenderRunnable.class);

    public MailSenderRunnable(MailSender sender) {
        this.sender = sender;
    }

    @Override
    public void run() {
        this.alive = true;
        try {
            this.mainLoop();
        }
        catch (InterruptedException e) {
            this.stop();
        }
    }

    protected void mainLoop() throws InterruptedException {
        HashSet<String> idsToMarkAsSent = new HashSet<String>();
        byte pollIntervalMultiplier = 1;
        while (this.alive) {
            long sleep;
            long now = System.currentTimeMillis();
            int serverErrors = this.sender.runOnce(idsToMarkAsSent);
            if (serverErrors < 0) continue;
            if (serverErrors > 0) {
                if (pollIntervalMultiplier < 10) {
                    pollIntervalMultiplier = (byte)(pollIntervalMultiplier + 1);
                    logger.debug("{} server errors, increased poll interval multiplier to {}", (Object)serverErrors, (Object)pollIntervalMultiplier);
                }
            } else {
                pollIntervalMultiplier = 1;
                logger.debug("No server errors, poll interval multiplier reset");
            }
            if ((sleep = this.pollInterval * (long)pollIntervalMultiplier - (System.currentTimeMillis() - now)) <= 0L) continue;
            logger.debug("Sleeping for {}ms", (Object)sleep);
            Thread.sleep(sleep);
        }
    }

    public void stop() {
        this.alive = false;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public boolean isAlive() {
        return this.alive;
    }
}

