/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.cache;

import com.manydesigns.portofino.cache.CacheResetEvent;
import com.manydesigns.portofino.cache.CacheResetListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheResetListenerRegistry {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(CacheResetListenerRegistry.class);
    protected final List<CacheResetListener> listeners = Collections.synchronizedList(new ArrayList());

    public List<CacheResetListener> getCacheResetListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReset(CacheResetEvent e) {
        ArrayList<CacheResetListener> listeners;
        List<CacheResetListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<CacheResetListener>(this.listeners);
        }
        for (CacheResetListener listener : listeners) {
            try {
                listener.handleReset(e);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
    }
}

