/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.Root;
import com.manydesigns.portofino.dispatcher.security.ResourcePermissions;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.jackson.TypeNameResolver;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.net.URLStreamHandlerFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;

class PortofinoModelResolver
extends ModelResolver {
    protected final Set<Class<?>> classesToIgnore = new HashSet();

    public PortofinoModelResolver(ObjectMapper mapper) {
        super(mapper);
        this.classesToIgnore.add(AnnotatedType.class);
        this.classesToIgnore.add(Certificate.class);
        this.classesToIgnore.add(Constructor.class);
        this.classesToIgnore.add(Executable.class);
        this.classesToIgnore.add(FileObject.class);
        this.classesToIgnore.add(GenericDeclaration.class);
        this.classesToIgnore.add(PublicKey.class);
        this.classesToIgnore.add(Resource.class);
        this.classesToIgnore.add(ResourcePermissions.class);
        this.classesToIgnore.add(ResourceResolver.class);
        this.classesToIgnore.add(Root.class);
        this.classesToIgnore.add(Type.class);
        this.classesToIgnore.add(URLStreamHandlerFactory.class);
    }

    public PortofinoModelResolver(ObjectMapper mapper, TypeNameResolver typeNameResolver) {
        super(mapper, typeNameResolver);
        this.classesToIgnore.add(AnnotatedType.class);
        this.classesToIgnore.add(Certificate.class);
        this.classesToIgnore.add(Constructor.class);
        this.classesToIgnore.add(Executable.class);
        this.classesToIgnore.add(FileObject.class);
        this.classesToIgnore.add(GenericDeclaration.class);
        this.classesToIgnore.add(PublicKey.class);
        this.classesToIgnore.add(Resource.class);
        this.classesToIgnore.add(ResourcePermissions.class);
        this.classesToIgnore.add(ResourceResolver.class);
        this.classesToIgnore.add(Root.class);
        this.classesToIgnore.add(Type.class);
        this.classesToIgnore.add(URLStreamHandlerFactory.class);
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (!super.shouldIgnoreClass(type)) {
            if (type instanceof Class) {
                return this.classesToIgnore.contains(type);
            }
            if (type instanceof ResolvedType) {
                return this.classesToIgnore.contains(((ResolvedType)type).getRawClass());
            }
        }
        return true;
    }
}

