/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.servlets;

import com.manydesigns.elements.annotations.Label;
import com.manydesigns.elements.annotations.Memory;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfo {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ServerInfo.class);
    protected final ServletContext servletContext;
    protected final String realPath;
    protected final String contextPath;
    protected final String servletContextName;
    protected final String serverInfo;
    protected final int servletApiMajor;
    protected final int servletApiMinor;
    protected final String servletApiVersion;
    protected final Runtime runTime;

    public ServerInfo(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.realPath = servletContext.getRealPath("/");
        logger.debug("Real path: {}", (Object)this.realPath);
        this.servletContextName = servletContext.getServletContextName();
        logger.debug("Servlet context name: {}", (Object)this.servletContextName);
        this.serverInfo = servletContext.getServerInfo();
        logger.debug("Server info: {}", (Object)this.serverInfo);
        this.servletApiMajor = servletContext.getMajorVersion();
        this.servletApiMinor = servletContext.getMinorVersion();
        this.servletApiVersion = MessageFormat.format("{0}.{1}", this.servletApiMajor, this.servletApiMinor);
        logger.debug("Servlet API version: {}", (Object)this.servletApiVersion);
        String tmp = null;
        try {
            Method method = servletContext.getClass().getMethod("getContextPath", new Class[0]);
            tmp = (String)method.invoke((Object)servletContext, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Cannot invoke getContextPath(). Required Servlet API >= 2.5");
        }
        catch (Exception e) {
            logger.debug("Uncaught exception", (Throwable)e);
        }
        this.contextPath = tmp;
        logger.debug("Context path: {}", (Object)this.contextPath);
        this.runTime = Runtime.getRuntime();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getRealPath() {
        return this.realPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    @Label(value="servlet API major")
    public int getServletApiMajor() {
        return this.servletApiMajor;
    }

    @Label(value="servlet API minor")
    public int getServletApiMinor() {
        return this.servletApiMinor;
    }

    @Label(value="servlet API version")
    public String getServletApiVersion() {
        return this.servletApiVersion;
    }

    @Memory
    public long getFreeMemory() {
        return this.runTime.freeMemory();
    }

    @Memory
    public long getUsedMemory() {
        return this.getTotalMemory() - this.getFreeMemory();
    }

    @Memory
    public long getTotalMemory() {
        return this.runTime.totalMemory();
    }

    @Memory
    public long getMaxMemory() {
        return this.runTime.maxMemory();
    }

    public int getAvailableProcessors() {
        return this.runTime.availableProcessors();
    }
}

