/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.portofino.security.SecurityLogic;
import com.manydesigns.portofino.shiro.GroupPermission;
import com.manydesigns.portofino.shiro.JSONWebToken;
import com.manydesigns.portofino.shiro.PlaintextHashFormat;
import com.manydesigns.portofino.shiro.PlaintextHashService;
import com.manydesigns.portofino.shiro.PortofinoPasswordService;
import com.manydesigns.portofino.shiro.PortofinoRealm;
import com.manydesigns.portofino.shiro.User;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.configuration2.Configuration;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.crypto.hash.format.HashFormat;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPortofinoRealm
extends AuthorizingRealm
implements PortofinoRealm {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final String JWT_EXPIRATION_PROPERTY = "jwt.expiration";
    public static final String JWT_SECRET_PROPERTY = "jwt.secret";
    @Autowired
    protected Configuration portofinoConfiguration;
    protected PasswordService passwordService;
    protected boolean legacyHashing = false;

    protected AbstractPortofinoRealm() {
        this.setup(new PlaintextHashService(), new PlaintextHashFormat());
        this.legacyHashing = true;
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof JSONWebToken || super.supports(token);
    }

    public AuthenticationInfo loadAuthenticationInfo(JSONWebToken token) {
        Object principal;
        Jwt jwt;
        Key key = this.getJWTKey();
        try {
            jwt = Jwts.parser().setSigningKey(key).parse(token.getPrincipal());
        }
        catch (JwtException e) {
            throw new AuthenticationException((Throwable)e);
        }
        Map body = (Map)jwt.getBody();
        String credentials = this.legacyHashing ? token.getCredentials() : this.encryptPassword(token.getCredentials());
        String base64Principal = (String)body.get("serialized-principal");
        byte[] serializedPrincipal = Base64.decode((String)base64Principal);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(serializedPrincipal));
            principal = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
        return new SimpleAuthenticationInfo(principal, (Object)credentials, this.getName());
    }

    @Override
    public String generateWebToken(Object principal) {
        Key key = this.getJWTKey();
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("principal", this.getPrincipalForWebToken(principal));
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bytes);
            objectOutputStream.writeObject(principal);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        claims.put("serialized-principal", bytes.toByteArray());
        int expireAfterMinutes = this.portofinoConfiguration.getInt(JWT_EXPIRATION_PROPERTY, 30);
        return Jwts.builder().setClaims(claims).setExpiration(new DateTime().plusMinutes(expireAfterMinutes).toDate()).signWith(key, SignatureAlgorithm.HS512).compact();
    }

    protected Object getPrincipalForWebToken(Object principal) {
        return this.cleanUserPrincipal(principal);
    }

    protected Object cleanUserPrincipal(Object principal) {
        return principal;
    }

    @NotNull
    protected Key getJWTKey() {
        String secret = this.portofinoConfiguration.getString(JWT_SECRET_PROPERTY);
        return new SecretKeySpec((byte[])Decoders.BASE64.decode((Object)secret), SignatureAlgorithm.HS512.getJcaName());
    }

    public AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Object principal = principals.getPrimaryPrincipal();
        Set<String> groups = this.getGroups(principal);
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo(groups);
        if (groups.contains(SecurityLogic.getAdministratorsGroup(this.portofinoConfiguration))) {
            info.addStringPermission("*");
        }
        GroupPermission permission = new GroupPermission(groups);
        info.setObjectPermissions(Collections.singleton(permission));
        return info;
    }

    @Override
    @NotNull
    public Set<String> getGroups(Object principal) {
        HashSet<String> groups = new HashSet<String>();
        groups.add(SecurityLogic.getAllGroup(this.portofinoConfiguration));
        if (principal == null) {
            groups.add(SecurityLogic.getAnonymousGroup(this.portofinoConfiguration));
        } else if (principal instanceof Serializable) {
            groups.add(SecurityLogic.getRegisteredGroup(this.portofinoConfiguration));
            groups.addAll(this.loadAuthorizationInfo((Serializable)principal));
        } else {
            throw new AuthorizationException("Invalid principal: " + principal);
        }
        return groups;
    }

    protected Collection<String> loadAuthorizationInfo(Serializable principal) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getGroups() {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        groups.add(SecurityLogic.getAllGroup(this.portofinoConfiguration));
        groups.add(SecurityLogic.getAnonymousGroup(this.portofinoConfiguration));
        groups.add(SecurityLogic.getRegisteredGroup(this.portofinoConfiguration));
        groups.add(SecurityLogic.getAdministratorsGroup(this.portofinoConfiguration));
        return groups;
    }

    @Override
    public Serializable getUserById(String encodedUserId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Serializable getUserByEmail(String email) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassAccessor getSelfRegisteredUserClassAccessor() {
        return JavaClassAccessor.getClassAccessor(User.class);
    }

    @Override
    public String getUserPrettyName(Serializable user) {
        return user.toString();
    }

    @Override
    public void verifyUser(Serializable user) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changePassword(Serializable user, String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateOneTimeToken(Serializable user) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String saveSelfRegisteredUser(Object user) {
        throw new UnsupportedOperationException();
    }

    protected void setup(HashService hashService, HashFormat hashFormat) {
        PortofinoPasswordService passwordService = new PortofinoPasswordService();
        passwordService.setHashService(hashService);
        passwordService.setHashFormat(hashFormat);
        PasswordMatcher passwordMatcher = new PasswordMatcher();
        passwordMatcher.setPasswordService((PasswordService)passwordService);
        this.setCredentialsMatcher((CredentialsMatcher)passwordMatcher);
        this.passwordService = passwordService;
        this.legacyHashing = false;
    }
}

