/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.setup;

import com.manydesigns.mail.queue.FileSystemMailQueue;
import com.manydesigns.mail.queue.LockingMailQueue;
import com.manydesigns.mail.queue.MailQueue;
import com.manydesigns.mail.sender.DefaultMailSender;
import com.manydesigns.mail.sender.MailSender;
import java.io.File;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailQueueSetup {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(MailQueueSetup.class);
    protected MailQueue mailQueue;
    protected MailSender mailSender;
    protected final Configuration mailConfiguration;

    public MailQueueSetup(Configuration mailConfiguration) {
        this.mailConfiguration = mailConfiguration;
    }

    public void setup() {
        boolean mailEnabled = this.mailConfiguration.getBoolean("mail.enabled", false);
        if (mailEnabled) {
            String mailQueueLocation = this.mailConfiguration.getString("mail.queue.location");
            boolean keepSent = this.mailConfiguration.getBoolean("mail.keep.sent", false);
            logger.info("Mail queue location: {}", (Object)mailQueueLocation);
            this.mailQueue = new LockingMailQueue(new FileSystemMailQueue(new File(mailQueueLocation)));
            this.mailQueue.setKeepSent(keepSent);
            String mailHost = this.mailConfiguration.getString("mail.smtp.host");
            if (null == mailHost) {
                logger.info("Mail queue is enabled but no SMTP server is configured. Mail won't be sent, only enqueued.");
            } else {
                logger.info("Mail queue is enabled, creating sender");
                int port = this.mailConfiguration.getInt("mail.smtp.port", 25);
                boolean ssl = this.mailConfiguration.getBoolean("mail.smtp.ssl.enabled", false);
                boolean tls = this.mailConfiguration.getBoolean("mail.smtp.tls.enabled", false);
                String login = this.mailConfiguration.getString("mail.smtp.login");
                String password = this.mailConfiguration.getString("mail.smtp.password");
                this.mailSender = new DefaultMailSender(this.mailQueue);
                this.mailSender.setServer(mailHost);
                this.mailSender.setLogin(login);
                this.mailSender.setPassword(password);
                this.mailSender.setPort(port);
                this.mailSender.setSsl(ssl);
                this.mailSender.setTls(tls);
                logger.info("Mail sender created.");
            }
        } else {
            logger.info("Mail queue is not enabled");
        }
    }

    public MailQueue getMailQueue() {
        return this.mailQueue;
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public Configuration getMailConfiguration() {
        return this.mailConfiguration;
    }
}

