/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.sender;

import com.manydesigns.mail.queue.MailParseException;
import com.manydesigns.mail.queue.MailQueue;
import com.manydesigns.mail.queue.model.Attachment;
import com.manydesigns.mail.queue.model.Email;
import com.manydesigns.mail.queue.model.Recipient;
import com.manydesigns.mail.sender.MailSender;
import com.sun.mail.smtp.SMTPAddressFailedException;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.IllegalWriteException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.SendFailedException;
import javax.mail.internet.ParseException;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailSender
implements MailSender {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final MailQueue queue;
    protected String server = "localhost";
    protected int port = 25;
    protected boolean ssl = false;
    protected boolean tls = false;
    protected String login;
    protected String password;
    public static final Logger logger = LoggerFactory.getLogger(DefaultMailSender.class);

    public DefaultMailSender(MailQueue queue) {
        this.queue = queue;
    }

    @Override
    public int runOnce(Set<String> idsToMarkAsSent) {
        List<String> ids;
        try {
            ids = this.queue.getEnqueuedEmailIds();
        }
        catch (Throwable e) {
            logger.error("Couldn't read email queue", e);
            return -1;
        }
        int serverErrors = 0;
        for (String id : ids) {
            Email email;
            if (idsToMarkAsSent.contains(id)) {
                logger.info("Mail with id {} already sent but mark failed, retrying", (Object)id);
                try {
                    this.queue.markSent(id);
                    idsToMarkAsSent.remove(id);
                }
                catch (Throwable e) {
                    logger.error("Couldn't mark mail as sent", e);
                }
                continue;
            }
            try {
                email = this.queue.loadEmail(id);
            }
            catch (MailParseException e) {
                logger.error("Mail with id " + id + " is corrupted, marking as failed", (Throwable)e);
                this.markFailed(id, e);
                continue;
            }
            catch (Throwable e) {
                logger.error("Unexpected error loading mail with id " + id + ", skipping", e);
                continue;
            }
            if (email == null) continue;
            boolean sent = false;
            try {
                logger.info("Sending email with id {}", (Object)id);
                this.send(email);
                sent = true;
            }
            catch (EmailException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ParseException || cause instanceof IllegalWriteException || cause instanceof MethodNotSupportedException) {
                    this.markFailed(id, cause);
                } else if (cause instanceof MessagingException) {
                    if (e.getCause() instanceof SendFailedException && e.getCause().getCause() instanceof SMTPAddressFailedException) {
                        logger.warn("Mail not sent due to known server error, marking as failed");
                        this.markFailed(id, e);
                    } else {
                        logger.warn("Mail not sent due to known server error, NOT marking as failed", (Throwable)e);
                        ++serverErrors;
                    }
                } else {
                    this.markFailed(id, e);
                }
            }
            catch (Throwable e) {
                this.markFailed(id, e);
            }
            if (!sent) continue;
            try {
                logger.info("Email with id {} sent, marking as sent ", (Object)id);
                this.queue.markSent(id);
            }
            catch (Throwable e) {
                logger.error("Couldn't mark mail as sent", e);
                idsToMarkAsSent.add(id);
            }
        }
        return serverErrors;
    }

    protected void markFailed(String id, Throwable e) {
        logger.error("Unrecognized error while sending mail, marking as failed", e);
        try {
            this.queue.markFailed(id);
        }
        catch (Throwable error) {
            logger.warn("Couldn't mark mail with id " + id + " as failed; it will probably fail again", error);
        }
    }

    protected void send(Email emailBean) throws EmailException {
        EmailAttachment emailAttachment;
        SimpleEmail email;
        logger.debug("Entering send(Email)");
        String textBody = emailBean.getTextBody();
        String htmlBody = emailBean.getHtmlBody();
        if (null == htmlBody) {
            if (emailBean.getAttachments().isEmpty()) {
                SimpleEmail simpleEmail = new SimpleEmail();
                simpleEmail.setMsg(textBody);
                email = simpleEmail;
            } else {
                MultiPartEmail multiPartEmail = new MultiPartEmail();
                multiPartEmail.setMsg(textBody);
                for (Attachment attachment : emailBean.getAttachments()) {
                    emailAttachment = new EmailAttachment();
                    emailAttachment.setName(attachment.getName());
                    emailAttachment.setDisposition(attachment.getDisposition());
                    emailAttachment.setDescription(attachment.getDescription());
                    emailAttachment.setPath(attachment.getFilePath());
                    multiPartEmail.attach(emailAttachment);
                }
                email = multiPartEmail;
            }
        } else {
            HtmlEmail htmlEmail = new HtmlEmail();
            htmlEmail.setHtmlMsg(htmlBody);
            if (textBody != null) {
                htmlEmail.setTextMsg(textBody);
            }
            for (Attachment attachment : emailBean.getAttachments()) {
                if (!attachment.isEmbedded()) {
                    emailAttachment = new EmailAttachment();
                    emailAttachment.setName(attachment.getName());
                    emailAttachment.setDisposition(attachment.getDisposition());
                    emailAttachment.setDescription(attachment.getDescription());
                    emailAttachment.setPath(attachment.getFilePath());
                    htmlEmail.attach(emailAttachment);
                    continue;
                }
                FileDataSource dataSource = new FileDataSource(new File(attachment.getFilePath()));
                htmlEmail.embed((DataSource)dataSource, attachment.getName(), attachment.getContentId());
            }
            email = htmlEmail;
        }
        if (null != this.login && null != this.password) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.login, this.password));
        }
        email.setHostName(this.server);
        email.setSmtpPort(this.port);
        email.setSubject(emailBean.getSubject());
        email.setFrom(emailBean.getFrom());
        for (Recipient recipient : emailBean.getRecipients()) {
            switch (recipient.getType()) {
                case TO: {
                    email.addTo(recipient.getAddress());
                    break;
                }
                case CC: {
                    email.addCc(recipient.getAddress());
                    break;
                }
                case BCC: {
                    email.addBcc(recipient.getAddress());
                }
            }
        }
        email.setSSLOnConnect(this.ssl);
        email.setStartTLSEnabled(this.tls);
        email.setSslSmtpPort(this.port + "");
        email.setCharset("UTF-8");
        email.send();
        logger.debug("Exiting send(Email)");
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @Override
    public boolean isTls() {
        return this.tls;
    }

    @Override
    public void setTls(boolean tls) {
        this.tls = tls;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }
}

