/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.PortofinoProperties;
import com.manydesigns.portofino.actions.ActionLogic;
import com.manydesigns.portofino.cache.CacheResetEvent;
import com.manydesigns.portofino.cache.CacheResetListener;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import com.manydesigns.portofino.resourceactions.custom.CustomAction;
import com.manydesigns.portofino.resourceactions.form.FormAction;
import com.manydesigns.portofino.resourceactions.form.TableFormAction;
import com.manydesigns.portofino.resourceactions.registry.ActionRegistry;
import com.manydesigns.portofino.rest.PortofinoApplicationRoot;
import com.manydesigns.portofino.shiro.SecurityClassRealm;
import com.manydesigns.portofino.shiro.SelfRegisteringShiroFilter;
import io.jsonwebtoken.io.Encoders;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.util.Initializable;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.web.env.EnvironmentLoader;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;

public class ResourceActionsModule
implements Module,
ApplicationContextAware {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String ACTIONS_DIRECTORY = "actionsDirectory";
    @Autowired
    public ServletContext servletContext;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.portofinoConfiguration")
    public Configuration configuration;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.portofinoConfigurationFile")
    public FileBasedConfigurationBuilder configurationFile;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.application.directory")
    public FileObject applicationDirectory;
    @Autowired
    public CodeBase codeBase;
    @Autowired
    public CacheResetListenerRegistry cacheResetListenerRegistry;
    protected EnvironmentLoader environmentLoader = new EnvironmentLoader();
    protected ApplicationContext applicationContext;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final Logger logger = LoggerFactory.getLogger(ResourceActionsModule.class);

    @Override
    public String getModuleVersion() {
        return PortofinoProperties.getPortofinoVersion();
    }

    @Override
    public String getName() {
        return "ResourceActions";
    }

    @PostConstruct
    public void init() throws FileSystemException {
        logger.debug("Initializing dispatcher");
        ActionLogic.init(this.configuration);
        FileObject actionsDirectory = this.getActionsDirectory(this.configuration, this.applicationDirectory);
        logger.info("Actions directory: " + actionsDirectory);
        if (this.configuration.getBoolean("groovy.preloadPages", false)) {
            logger.info("Preloading actions");
            try {
                ResourceResolver resourceResolver = PortofinoApplicationRoot.getRootFactory().createRoot().getResourceResolver();
                this.preloadResourceActions(actionsDirectory, resourceResolver);
            }
            catch (Exception e) {
                logger.warn("Could not preload actions", (Throwable)e);
            }
        }
        if (this.configuration.getBoolean("groovy.preloadClasses", false)) {
            logger.info("Preloading Groovy classes");
            this.preloadClasses(this.codeBase.getRoot());
        }
        this.cacheResetListenerRegistry.getCacheResetListeners().add(new ConfigurationCacheResetListener());
        if (!this.configuration.containsKey("jwt.secret")) {
            String jwtSecret = (String)Encoders.BASE64.encode((Object)(UUID.randomUUID() + UUID.randomUUID().toString()).getBytes());
            logger.warn("No jwt.secret property was set, so we generated one: {}.", (Object)jwtSecret);
            this.configuration.setProperty("jwt.secret", (Object)jwtSecret);
            try {
                this.configurationFile.save();
                logger.info("Saved configuration file {}", (Object)this.configurationFile.getFileHandler().getFile().getAbsolutePath());
            }
            catch (ConfigurationException e) {
                logger.warn("Configuration could not be saved", (Throwable)e);
            }
        }
        logger.info("Initializing Shiro environment");
        WebEnvironment environment = this.environmentLoader.initEnvironment(this.servletContext);
        RealmSecurityManager rsm = (RealmSecurityManager)environment.getWebSecurityManager();
        SelfRegisteringShiroFilter shiroFilter = SelfRegisteringShiroFilter.get(this.servletContext);
        if (shiroFilter != null) {
            try {
                shiroFilter.init();
            }
            catch (Exception e) {
                logger.error("Could not initialize the Shiro filter", (Throwable)e);
                this.status = ModuleStatus.FAILED;
                return;
            }
        }
        logger.debug("Creating SecurityClassRealm");
        SecurityClassRealm realm = new SecurityClassRealm(this.codeBase, "Security", this.applicationContext);
        try {
            LifecycleUtils.init((Initializable)realm);
        }
        catch (Exception e) {
            logger.warn("Security class not found or invalid or initialization failed. We will reload and/or initialize it on next use.", (Throwable)e);
        }
        rsm.setRealm((Realm)realm);
        this.status = ModuleStatus.STARTED;
    }

    @Bean
    public ActionRegistry getResourceActionRegistry() {
        logger.debug("Creating actions registry");
        ActionRegistry actionRegistry = new ActionRegistry();
        actionRegistry.register(CustomAction.class);
        actionRegistry.register(FormAction.class);
        actionRegistry.register(TableFormAction.class);
        return actionRegistry;
    }

    @Bean(name={"actionsDirectory"})
    public FileObject getActionsDirectory(@Autowired @Qualifier(value="com.manydesigns.portofino.portofinoConfiguration") Configuration configuration, @Autowired @Qualifier(value="com.manydesigns.portofino.application.directory") FileObject applicationDirectory) throws FileSystemException {
        String actionsDirectory = configuration.getString("portofino.actions.path", "actions");
        return applicationDirectory.resolveFile(actionsDirectory);
    }

    protected void preloadResourceActions(FileObject directory, ResourceResolver resourceResolver) throws FileSystemException {
        for (FileObject child : directory.getChildren()) {
            logger.debug("visit {}", (Object)child);
            if (child.getType() != FileType.FOLDER || child.equals(directory) || child.equals(directory.getParent())) continue;
            try {
                ((Class)resourceResolver.resolve(child, Class.class)).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                logger.warn("ResourceAction preload failed for actionDescriptor " + child.getName().getPath(), t);
            }
            this.preloadResourceActions(child, resourceResolver);
        }
    }

    protected void preloadClasses(FileObject directory) {
        try {
            for (FileObject file : directory.getChildren()) {
                logger.debug("visit {}", (Object)file);
                if (file.getType() == FileType.FOLDER) {
                    if (file.equals(directory) || file.equals(directory.getParent())) continue;
                    this.preloadClasses(file);
                    continue;
                }
                String extension = file.getName().getExtension();
                String className = this.codeBase.getRoot().getName().getRelativeName(file.getName());
                if (!StringUtils.isEmpty((CharSequence)extension)) {
                    className = className.substring(0, className.length() - extension.length() - 1);
                }
                logger.debug("Preloading " + className);
                try {
                    this.codeBase.loadClass(className);
                }
                catch (Throwable t) {
                    logger.warn("Class preload failed for " + className, t);
                }
            }
        }
        catch (FileSystemException e) {
            logger.warn("Could not preload classes under " + directory, (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        logger.info("Destroying Shiro environment...");
        this.environmentLoader.destroyEnvironment(this.servletContext);
        this.status = ModuleStatus.DESTROYED;
    }

    @Override
    public ModuleStatus getStatus() {
        return this.status;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class ConfigurationCacheResetListener
    implements CacheResetListener {
        private ConfigurationCacheResetListener() {
        }

        @Override
        public void handleReset(CacheResetEvent e) {
            ActionLogic.clearConfigurationCache();
        }
    }
}

