/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest.actions.mail;

import com.manydesigns.mail.sender.MailSender;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Path(value="/actions/mail-sender-run")
public class SendMailAction {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(SendMailAction.class);
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest request;

    @GET
    public Response execute() {
        MailSender mailSender;
        String clientIP = this.request.getRemoteAddr();
        try {
            InetAddress clientAddr = InetAddress.getByName(clientIP);
            if (!SendMailAction.isLocalIPAddress(clientAddr)) {
                logger.warn("Received request from non-local addr, forbidding access: {}", (Object)clientAddr);
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
        }
        catch (UnknownHostException e) {
            logger.error("Could not determine request address", (Throwable)e);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            mailSender = (MailSender)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext).getBean(MailSender.class);
        }
        catch (Exception e) {
            logger.debug("Mail sender not found", (Throwable)e);
            return Response.serverError().entity((Object)"Mail Sender not active").build();
        }
        logger.debug("Sending pending email messages");
        HashSet<String> idsToMarkAsSent = new HashSet<String>();
        int serverErrors = mailSender.runOnce(idsToMarkAsSent);
        if (serverErrors < 0) {
            logger.warn("Mail sender did not run.");
        } else if (serverErrors > 0) {
            logger.warn("Mail sender encountered {} server errors.", (Object)serverErrors);
        }
        if (!idsToMarkAsSent.isEmpty()) {
            logger.warn("The following email(s) were sent but could not be marked as sent; they will be sent twice! {}", idsToMarkAsSent);
        }
        return Response.noContent().build();
    }

    public static boolean isLocalIPAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }
}

