/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import com.manydesigns.portofino.actions.Permissions;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.shiro.ActionPermission;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupPermission
implements Permission {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final Collection<String> groups;
    public static final Logger logger = LoggerFactory.getLogger(GroupPermission.class);

    public GroupPermission(Collection<String> groups) {
        this.groups = groups;
    }

    public boolean implies(Permission p) {
        if (p instanceof GroupPermission) {
            GroupPermission gp = (GroupPermission)p;
            return gp.groups.containsAll(this.groups) && this.groups.containsAll(gp.groups);
        }
        if (p instanceof ActionPermission) {
            ActionPermission pp = (ActionPermission)p;
            return GroupPermission.hasPermissions(pp.getCalculatedPermissions(), this.groups, pp.getAccessLevel(), pp.getPermissions());
        }
        return false;
    }

    public static boolean hasPermissions(Permissions configuration, Collection<String> groups, AccessLevel level, String ... permissions) {
        boolean hasLevel = level == null;
        boolean hasPermissions = true;
        HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(permissions.length);
        for (String groupId : groups) {
            Set<String> perms;
            AccessLevel actualLevel = configuration.getActualLevels().get(groupId);
            if (actualLevel == AccessLevel.DENY) {
                return false;
            }
            if (!hasLevel && actualLevel != null && actualLevel.isGreaterThanOrEqual(level)) {
                hasLevel = true;
            }
            if ((perms = configuration.getActualPermissions().get(groupId)) == null) continue;
            for (String permission : permissions) {
                if (!perms.contains(permission)) continue;
                permMap.put(permission, true);
            }
        }
        for (String permission : permissions) {
            hasPermissions &= permMap.containsKey(permission);
        }
        boolean bl = hasPermissions = hasLevel && hasPermissions;
        if (!hasPermissions) {
            logger.debug("User does not have permissions. User's groups: {}", groups);
        }
        return hasPermissions;
    }
}

