/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import com.manydesigns.portofino.shiro.JSONWebToken;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTFilter
extends PathMatchingFilter {
    private static final Logger logger = LoggerFactory.getLogger(JWTFilter.class);

    protected boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        if ("OPTIONS".equals(httpRequest.getMethod())) {
            return true;
        }
        String jwt = JWTFilter.getJSONWebToken(httpRequest);
        if (jwt == null) {
            logger.debug("JWT not found, proceeding with the request");
            return true;
        }
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            subject.logout();
        }
        try {
            subject.login((AuthenticationToken)new JSONWebToken(jwt));
            return true;
        }
        catch (AuthenticationException e) {
            logger.warn("Failed JWT authentication to " + httpRequest.getRequestURL(), (Throwable)e);
            HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
            httpResponse.setStatus(401);
            return false;
        }
    }

    @Nullable
    public static String getJSONWebToken(HttpServletRequest httpRequest) {
        String jwt = httpRequest.getHeader("Authorization");
        if (jwt != null && jwt.startsWith("Bearer ")) {
            jwt = jwt.substring("Bearer ".length());
        }
        return jwt;
    }
}

