/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import com.manydesigns.portofino.shiro.PortofinoRealm;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;

public class ShiroUtils {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";

    public static Object getPrimaryPrincipal(Subject s) {
        return ShiroUtils.getPrincipal(s, 0);
    }

    public static Object getPrincipal(Subject s, int i) {
        Object principal = s.getPrincipal();
        if (principal instanceof PrincipalCollection) {
            List principals = ((PrincipalCollection)principal).asList();
            return principals.get(i);
        }
        if (i == 0) {
            return principal;
        }
        throw new IndexOutOfBoundsException("The subject has only 1 principal, index " + i + " is not valid");
    }

    public static PortofinoRealm getPortofinoRealm() {
        RealmSecurityManager realmSecurityManager = (RealmSecurityManager)SecurityUtils.getSecurityManager();
        PortofinoRealm portofinoRealm = (PortofinoRealm)realmSecurityManager.getRealms().iterator().next();
        return portofinoRealm;
    }

    public static Serializable getUserId(Subject subject) {
        PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
        Serializable principal = (Serializable)ShiroUtils.getPrimaryPrincipal(subject);
        if (portofinoRealm != null) {
            return portofinoRealm.getUserId(principal);
        }
        return principal;
    }
}

