/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.mail.queue;

import com.manydesigns.elements.util.ElementsFileUtils;
import com.manydesigns.elements.util.RandomUtil;
import com.manydesigns.mail.queue.MailParseException;
import com.manydesigns.mail.queue.MailQueue;
import com.manydesigns.mail.queue.QueueException;
import com.manydesigns.mail.queue.model.Attachment;
import com.manydesigns.mail.queue.model.Email;
import com.manydesigns.mail.queue.model.Recipient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemMailQueue
implements MailQueue {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final File queuedDirectory;
    protected final File sentDirectory;
    protected final File failedDirectory;
    protected final JAXBContext jaxbContext;
    protected boolean keepSent;
    protected static final Logger logger = LoggerFactory.getLogger(FileSystemMailQueue.class);

    public FileSystemMailQueue(File directory) {
        this.queuedDirectory = new File(directory, "queue");
        this.sentDirectory = new File(directory, "sent");
        this.failedDirectory = new File(directory, "failed");
        if (!ElementsFileUtils.ensureDirectoryExistsAndWritable((File)this.queuedDirectory)) {
            logger.warn("Directory does not exist or is not writable: {}", (Object)this.queuedDirectory);
        }
        if (!ElementsFileUtils.ensureDirectoryExistsAndWritable((File)this.sentDirectory)) {
            logger.warn("Directory does not exist or is not writable: {}", (Object)this.sentDirectory);
        }
        if (!ElementsFileUtils.ensureDirectoryExistsAndWritable((File)this.failedDirectory)) {
            logger.warn("Directory does not exist or is not writable: {}", (Object)this.failedDirectory);
        }
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Email.class, Recipient.class});
        }
        catch (JAXBException e) {
            throw new Error("Couldn't create jaxb context", e);
        }
    }

    protected void checkDirectory(File file) throws QueueException {
        if (!ElementsFileUtils.ensureDirectoryExistsAndWritable((File)file)) {
            throw new QueueException("Invalid directory " + file.getAbsolutePath());
        }
    }

    protected void checkDirectories() throws QueueException {
        this.checkDirectory(this.queuedDirectory);
        this.checkDirectory(this.sentDirectory);
        this.checkDirectory(this.failedDirectory);
    }

    @Override
    public String enqueue(Email email) throws QueueException {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            String emailId = RandomUtil.createRandomId((int)20);
            File destinationFile = this.getEmailFile(emailId);
            this.checkDirectory(this.queuedDirectory);
            if (!email.getAttachments().isEmpty()) {
                File attachDir = this.getEmailAttachmentsDirectory(emailId);
                this.checkDirectory(attachDir);
                for (Attachment attachment : email.getAttachments()) {
                    String attachmentId = RandomUtil.createRandomId((int)20);
                    File attachmentFile = new File(attachDir, attachmentId + ".bin");
                    try (InputStream inputStream = attachment.getInputStream();
                         FileOutputStream fos = new FileOutputStream(attachmentFile);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
                    }
                    attachment.setFilePath(attachmentFile.getAbsolutePath());
                }
            }
            marshaller.marshal((Object)email, destinationFile);
            return emailId;
        }
        catch (Exception e) {
            throw new QueueException("Couldn't enqueue mail", e);
        }
    }

    protected File getEmailFile(String emailId) {
        return RandomUtil.getCodeFile((File)this.queuedDirectory, (String)"email-{0}.xml", (String)emailId);
    }

    protected File getEmailAttachmentsDirectory(String emailId) {
        return RandomUtil.getCodeFile((File)this.queuedDirectory, (String)"email-{0}-attachments", (String)emailId);
    }

    @Override
    public List<String> getEnqueuedEmailIds() throws QueueException {
        this.checkDirectory(this.queuedDirectory);
        ArrayList<String> ids = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^email-(.*)\\.xml$");
        for (String filename : this.queuedDirectory.list()) {
            Matcher matcher = pattern.matcher(filename);
            if (!matcher.matches()) continue;
            logger.debug("Path matched: {}", (Object)filename);
            ids.add(matcher.group(1));
        }
        return ids;
    }

    @Override
    public Email loadEmail(String id) throws QueueException {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            File emailFile = this.getEmailFile(id);
            if (emailFile.exists()) {
                logger.debug("Found email with id: {}", (Object)id);
                Email email = (Email)unmarshaller.unmarshal(emailFile);
                return email;
            }
            logger.debug("Email with id {} not found", (Object)id);
            return null;
        }
        catch (JAXBException e) {
            throw new MailParseException("Couldn't parse email", e);
        }
        catch (Exception e) {
            throw new QueueException("Couldn't load email", e);
        }
    }

    @Override
    public void markSent(String id) throws QueueException {
        this.checkDirectories();
        try {
            File emailFile = this.getEmailFile(id);
            if (emailFile.exists()) {
                File attachmentsDir = this.getEmailAttachmentsDirectory(id);
                if (this.keepSent) {
                    logger.info("Moving email with id {} to sent directory", (Object)id);
                    FileUtils.moveToDirectory((File)emailFile, (File)this.sentDirectory, (boolean)false);
                    if (attachmentsDir.exists()) {
                        FileUtils.moveToDirectory((File)attachmentsDir, (File)this.sentDirectory, (boolean)false);
                    }
                } else {
                    logger.info("Deleting sent email with id {}", (Object)id);
                    boolean success = emailFile.delete();
                    if (attachmentsDir.exists()) {
                        for (File attachmentFile : attachmentsDir.listFiles()) {
                            success = attachmentFile.delete() && success;
                        }
                        boolean bl = success = attachmentsDir.delete() && success;
                    }
                    if (!success) {
                        throw new QueueException("Couldn't mark mail as sent");
                    }
                }
            } else {
                logger.debug("Not marking email with id {} as sent", (Object)id);
            }
        }
        catch (IOException e) {
            throw new Error("Couldn't mark mail as sent", e);
        }
    }

    @Override
    public void markFailed(String id) throws QueueException {
        this.checkDirectories();
        try {
            File emailFile = this.getEmailFile(id);
            if (emailFile.exists()) {
                File attachmentsDir = this.getEmailAttachmentsDirectory(id);
                logger.info("Marking email with id {} as failed", (Object)id);
                FileUtils.moveToDirectory((File)emailFile, (File)this.failedDirectory, (boolean)false);
                if (attachmentsDir.exists()) {
                    FileUtils.moveToDirectory((File)attachmentsDir, (File)this.failedDirectory, (boolean)false);
                }
            } else {
                logger.debug("Not marking email with id {} as failed", (Object)id);
            }
        }
        catch (IOException e) {
            throw new QueueException("Couldn't mark mail as failed", e);
        }
    }

    public File getQueuedDirectory() {
        return this.queuedDirectory;
    }

    public File getSentDirectory() {
        return this.sentDirectory;
    }

    public File getFailedDirectory() {
        return this.failedDirectory;
    }

    @Override
    public boolean isKeepSent() {
        return this.keepSent;
    }

    @Override
    public void setKeepSent(boolean keepSent) {
        this.keepSent = keepSent;
    }
}

