/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.servlets;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.configuration.BeanLookup;
import com.manydesigns.elements.crypto.KeyManager;
import com.manydesigns.elements.servlet.AttributeMap;
import com.manydesigns.elements.util.ElementsFileUtils;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.ResourceResolvers;
import com.manydesigns.portofino.dispatcher.web.DispatcherInitializer;
import com.manydesigns.portofino.i18n.I18nUtils;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.rest.PortofinoRoot;
import com.manydesigns.portofino.servlets.ServerInfo;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PortofinoListener
extends DispatcherInitializer
implements ServletContextListener,
ServletContextAttributeListener {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String SEPARATOR = "--------------------------------------------------------------------------------";
    public static final String SERVER_INFO = "com.manydesigns.portofino.serverInfo";
    public static final String PORTOFINO_CONFIGURATION_FILE_PROPERTY = "portofino.configuration.file";
    protected Configuration elementsConfiguration;
    protected FileBasedConfigurationBuilder<PropertiesConfiguration> configurationFile;
    protected ServletContext servletContext;
    protected ServerInfo serverInfo;
    public static final Logger logger = LoggerFactory.getLogger(PortofinoListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ElementsThreadLocals.setupDefaultElementsContext();
            ServletContext servletContext = servletContextEvent.getServletContext();
            ElementsThreadLocals.setServletContext((ServletContext)servletContext);
            AttributeMap servletContextAttributeMap = AttributeMap.createAttributeMap((ServletContext)servletContext);
            ElementsThreadLocals.getOgnlContext().put((Object)"servletContext", (Object)servletContextAttributeMap);
            this.init(servletContextEvent);
            String actionsDirectory = this.configuration.getString("portofino.actions.path", "actions");
            this.initApplicationRoot(servletContext, actionsDirectory);
            String portofinoVersion = Module.getPortofinoVersion();
            String lineSeparator = System.getProperty("line.separator", "\n");
            logger.info(lineSeparator + SEPARATOR + lineSeparator + "--- ManyDesigns Portofino " + portofinoVersion + " started successfully" + lineSeparator + "--- Context path: {}" + lineSeparator + "--- Real path: {}" + lineSeparator + "--- Visit http://portofino.manydesigns.com for news, documentation, issue tracker, community forums, commercial support!" + lineSeparator + SEPARATOR, (Object)this.serverInfo.getContextPath(), (Object)this.serverInfo.getRealPath());
            String versionCheckUrl = this.configuration.getString("portofino.version.check.url", "https://portofino.manydesigns.com/version-check.jsp");
            if (!"off".equalsIgnoreCase(versionCheckUrl)) {
                try {
                    this.checkForNewVersion(portofinoVersion, versionCheckUrl);
                }
                catch (Throwable t) {
                    logger.warn("Version check failed unexpectedly", t);
                }
            }
        }
        catch (Throwable e) {
            logger.error("Could not start ManyDesigns Portofino", e);
            throw new Error(e);
        }
        finally {
            ElementsThreadLocals.removeElementsContext();
        }
    }

    private void init(ServletContextEvent servletContextEvent) {
        FileSystemManager manager;
        MDC.clear();
        this.servletContext = servletContextEvent.getServletContext();
        this.serverInfo = new ServerInfo(this.servletContext);
        this.servletContext.setAttribute(SERVER_INFO, (Object)this.serverInfo);
        this.elementsConfiguration = ElementsProperties.getConfiguration();
        String applicationDirectoryPath = this.servletContext.getInitParameter("portofino.application.directory");
        try {
            manager = VFS.getManager();
        }
        catch (FileSystemException e) {
            logger.error("Failed to obtain VFS manager", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (applicationDirectoryPath != null) {
            try {
                ConfigurationInterpolator interpolator = new BaseConfiguration().getInterpolator();
                interpolator.registerLookups(this.getConfigurationLookups());
                applicationDirectoryPath = (String)interpolator.interpolate((Object)applicationDirectoryPath);
                if (!StringUtils.isEmpty((String)applicationDirectoryPath)) {
                    this.applicationRoot = manager.resolveFile(applicationDirectoryPath);
                    if (this.applicationRoot.getType() != FileType.FOLDER) {
                        logger.error("Configured application directory " + applicationDirectoryPath + " is not a directory");
                        this.applicationRoot = null;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Configured application directory " + applicationDirectoryPath + " is not valid", (Throwable)e);
            }
        }
        if (this.applicationRoot == null) {
            try {
                logger.info("Using default application directory (WEB-INF)");
                this.applicationRoot = manager.resolveFile(this.serverInfo.getRealPath()).resolveFile("WEB-INF");
            }
            catch (FileSystemException e) {
                logger.error("Failed to obtain application real path", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        logger.info("Application directory: {}", (Object)this.applicationRoot.getName().getPath());
        try {
            this.loadConfiguration();
        }
        catch (Exception e) {
            logger.error("Could not load configuration", (Throwable)e);
            throw new Error(e);
        }
        this.servletContext.setAttribute("com.manydesigns.portofino.application.directory", (Object)this.applicationRoot);
        this.servletContext.setAttribute("com.manydesigns.portofino.portofinoConfiguration", (Object)this.configuration);
        this.servletContext.setAttribute("com.manydesigns.portofino.portofinoConfigurationFile", this.configurationFile);
        if (!KeyManager.isActive()) {
            try {
                logger.info("Initializing KeyManager ");
                KeyManager.init((Configuration)this.configuration);
            }
            catch (Exception e) {
                logger.error("Could not initialize KeyManager", (Throwable)e);
            }
        }
        I18nUtils.setupResourceBundleManager(this.applicationRoot, this.servletContext);
        logger.info("Servlet API version is " + this.serverInfo.getServletApiVersion());
        if (this.serverInfo.getServletApiMajor() < 3) {
            String msg = "Servlet API version should be >= 3.0.";
            logger.warn(msg);
        }
        String encoding = this.configuration.getString("url.encoding", "UTF-8");
        logger.info("URL character encoding is set to " + encoding + ". Make sure the web server uses the same encoding to parse URLs.");
        if (!Charset.isSupported(encoding)) {
            logger.error("The encoding is not supported by the JVM!");
        }
    }

    protected void checkForNewVersion(String portofinoVersion, String versionCheckUrl) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(versionCheckUrl).queryParam("version", new Object[]{portofinoVersion});
        Future responseFuture = target.request().async().get();
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                Response response = (Response)responseFuture.get();
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    String latestVersion = ((String)response.readEntity(String.class)).trim();
                    if (Objects.equals(portofinoVersion, latestVersion)) {
                        logger.info("Your installation of Portofino is up-to-date");
                    } else {
                        String lineSeparator = System.getProperty("line.separator", "\n");
                        logger.info(lineSeparator + SEPARATOR + lineSeparator + "A new version of Portofino is available: " + latestVersion + lineSeparator + SEPARATOR);
                    }
                } else {
                    logger.info("Version check failed: " + response.getStatus());
                }
                String message = response.getHeaderString("X-Message");
                if (message != null) {
                    logger.info(message);
                }
            }
            catch (Exception e) {
                logger.info("Could not check for new version: " + e.getMessage());
                logger.debug("Additional information", (Throwable)e);
            }
        });
    }

    protected FileObject getCodeBaseRoot() throws FileSystemException {
        FileObject codeBaseRoot = this.applicationRoot.resolveFile("classes");
        String classpath = codeBaseRoot.getName().getPath();
        logger.info("Initializing codebase with classpath: " + classpath);
        ElementsFileUtils.ensureDirectoryExistsAndWarnIfNotWritable((File)new File(classpath));
        return codeBaseRoot;
    }

    protected PortofinoRoot getRoot(FileObject actionsDirectory, ResourceResolvers resourceResolver) throws Exception {
        return PortofinoRoot.get(actionsDirectory, (ResourceResolver)resourceResolver);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        MDC.clear();
    }

    protected void loadConfiguration() throws ConfigurationException, FileSystemException {
        FileObject localConfigurationFile;
        FileObject configurationFile = this.applicationRoot.resolveFile("portofino.properties");
        PropertiesBuilderParameters parameters = (PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setPrefixLookups(this.getConfigurationLookups())).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        String path = configurationFile.getName().getURI();
        parameters.setFileName(path);
        this.configurationFile = new Configurations().propertiesBuilder(path).configure(new BuilderParameters[]{parameters});
        this.configuration = (Configuration)this.configurationFile.getConfiguration();
        this.servletContext.setAttribute("portofino.configuration", (Object)this.configuration);
        String localConfigurationPath = null;
        try {
            localConfigurationPath = System.getProperty(PORTOFINO_CONFIGURATION_FILE_PROPERTY);
        }
        catch (SecurityException e) {
            logger.warn("Reading system properties is forbidden. Will read configuration file from standard location.", (Throwable)e);
        }
        String localConfigurationFromDeploymentDescriptor = this.servletContext.getInitParameter(PORTOFINO_CONFIGURATION_FILE_PROPERTY);
        if (localConfigurationFromDeploymentDescriptor != null) {
            logger.debug("Read configuration file location from deployment descriptor");
            localConfigurationPath = localConfigurationFromDeploymentDescriptor;
        }
        if (localConfigurationPath == null) {
            localConfigurationPath = this.configuration.getString("portofino-local.properties", this.applicationRoot.resolveFile("portofino-local.properties").getName().getURI());
        }
        if ((localConfigurationFile = VFS.getManager().resolveFile(localConfigurationPath)).exists()) {
            logger.info("Local configuration file: {}", (Object)localConfigurationFile);
            parameters.setFileName(localConfigurationPath);
            this.configurationFile = new Configurations().propertiesBuilder(localConfigurationPath).configure(new BuilderParameters[]{parameters});
            PropertiesConfiguration localConfiguration = (PropertiesConfiguration)this.configurationFile.getConfiguration();
            CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
            compositeConfiguration.addConfiguration((Configuration)localConfiguration, true);
            compositeConfiguration.addConfiguration(this.configuration);
            this.configuration = compositeConfiguration;
        } else {
            logger.info("No local configuration found at {}", (Object)localConfigurationPath);
        }
    }

    public Map<String, Lookup> getConfigurationLookups() {
        HashMap<String, Lookup> lookupMap = new HashMap<String, Lookup>();
        lookupMap.put("serverInfo", (Lookup)new BeanLookup((Object)this.serverInfo));
        return lookupMap;
    }

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        logger.debug("Servlet context attribute added: " + servletContextAttributeEvent.getName() + " = " + servletContextAttributeEvent.getValue());
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        logger.debug("Servlet context attribute removed: " + servletContextAttributeEvent.getName() + " = " + servletContextAttributeEvent.getValue());
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        logger.debug("Servlet context attribute replaced: " + servletContextAttributeEvent.getName() + " = " + servletContextAttributeEvent.getValue());
    }
}

