/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions.login;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.forms.FormBuilder;
import com.manydesigns.elements.messages.RequestMessages;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.util.ReflectionUtil;
import com.manydesigns.mail.queue.MailQueue;
import com.manydesigns.mail.queue.QueueException;
import com.manydesigns.mail.queue.model.Email;
import com.manydesigns.mail.queue.model.Recipient;
import com.manydesigns.portofino.resourceactions.AbstractResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionName;
import com.manydesigns.portofino.resourceactions.annotations.ScriptTemplate;
import com.manydesigns.portofino.security.SecurityLogic;
import com.manydesigns.portofino.shiro.ExistingUserException;
import com.manydesigns.portofino.shiro.JSONWebToken;
import com.manydesigns.portofino.shiro.JWTFilter;
import com.manydesigns.portofino.shiro.PasswordResetToken;
import com.manydesigns.portofino.shiro.PortofinoRealm;
import com.manydesigns.portofino.shiro.ShiroUtils;
import com.manydesigns.portofino.shiro.SignUpToken;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.subject.Subject;
import org.json.JSONStringer;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScriptTemplate(value="script_template.groovy")
@ResourceActionName(value="Login")
public class DefaultLoginAction
extends AbstractResourceAction {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    private static final Logger logger = LoggerFactory.getLogger(DefaultLoginAction.class);
    @Autowired(required=false)
    public MailQueue mailQueue;

    @Path(value="capabilities")
    @GET
    @Produces(value={"application/json"})
    public Map getCapabilities() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("supportsSelfRegistration", ShiroUtils.getPortofinoRealm().supportsSelfRegistration());
        return map;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response login(@FormParam(value="username") String username, @FormParam(value="password") String password) throws AuthenticationException {
        return Response.ok((Object)this.doLogin(username, password)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response login(LoginData data) {
        return Response.ok((Object)this.doLogin(data.username, data.password)).build();
    }

    protected String doLogin(String username, String password) {
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated()) {
            try {
                UsernamePasswordToken usernamePasswordToken = new UsernamePasswordToken(username, password);
                usernamePasswordToken.setRememberMe(false);
                subject.login((AuthenticationToken)usernamePasswordToken);
                logger.info("User {} logged in", (Object)ShiroUtils.getUserId(subject));
                Object principal = subject.getPrincipal();
                subject.logout();
                PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
                String jwt = portofinoRealm.generateWebToken(principal);
                subject.login((AuthenticationToken)new JSONWebToken(jwt));
                return this.userInfo(subject, portofinoRealm, jwt);
            }
            catch (AuthenticationException e) {
                logger.warn("Login failed for '" + username + "': " + e.getMessage(), (Throwable)e);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        return this.getUserInfo();
    }

    @Path(value=":renew-token")
    @POST
    @Deprecated
    public String renewToken() {
        return this.refreshToken();
    }

    @Path(value=":refresh-token")
    @POST
    public String refreshToken() {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            Object principal = subject.getPrincipal();
            subject.logout();
            PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
            String token = portofinoRealm.generateWebToken(principal);
            subject.login((AuthenticationToken)new JSONWebToken(token));
            return token;
        }
        logger.warn("Token renew request for unauthenticated user");
        throw new WebApplicationException(Response.Status.FORBIDDEN);
    }

    @GET
    @Produces(value={"application/json"})
    @RequiresAuthentication
    public String getUserInfo() {
        Subject subject = SecurityUtils.getSubject();
        PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
        String jwt = JWTFilter.getJSONWebToken(this.context.getRequest());
        if (jwt == null) {
            subject.logout();
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.userInfo(subject, portofinoRealm, jwt);
    }

    public String userInfo(Subject subject, PortofinoRealm portofinoRealm, String jwt) {
        boolean administrator = SecurityLogic.isAdministrator(this.portofinoConfiguration);
        JSONStringer stringer = new JSONStringer();
        stringer.object().key("userId").value((Object)ShiroUtils.getUserId(subject)).key("displayName").value((Object)portofinoRealm.getUserPrettyName((Serializable)subject.getPrincipal())).key("administrator").value(administrator).key("groups").value(portofinoRealm.getGroups(subject.getPrincipal())).key("jwt").value((Object)jwt).endObject();
        return stringer.toString();
    }

    @Path(value=":send-reset-password-email")
    @POST
    public void sendResetPasswordEmail(ResetPasswordEmailRequest req) {
        if (SecurityUtils.getSubject().isAuthenticated()) {
            logger.debug("Already logged in");
            return;
        }
        PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
        try {
            Serializable user = portofinoRealm.getUserByEmail(req.email);
            if (user != null) {
                String token = portofinoRealm.generateOneTimeToken(user);
                String body = this.getResetPasswordEmailBody(req.siteNameOrAddress, req.loginPageUrl.replace("TOKEN", token));
                String from = this.portofinoConfiguration.getString("mail.from");
                String subject = ElementsThreadLocals.getText((String)"password.reset.confirmation.required", (Object[])new Object[0]);
                this.sendMail(from, req.email, subject, body);
            } else {
                logger.warn("Forgot password request for nonexistent email");
            }
        }
        catch (Exception e) {
            logger.error("Error during password reset", (Throwable)e);
            throw new WebApplicationException(ElementsThreadLocals.getText((String)"password.reset.failed", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected String getResetPasswordEmailBody(String site, String changePasswordLink) throws IOException {
        String countryIso = this.context.getRequest().getLocale().getLanguage().toLowerCase();
        InputStream is = DefaultLoginAction.class.getResourceAsStream("/com/manydesigns/portofino/actions/user/passwordResetEmail." + countryIso + ".html");
        if (is == null) {
            is = DefaultLoginAction.class.getResourceAsStream("/com/manydesigns/portofino/actions/user/passwordResetEmail.en.html");
        }
        try (InputStream stream = is;){
            String template = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            String string = template.replace("$link", changePasswordLink).replace("$site", site);
            return string;
        }
    }

    protected String getConfirmSignUpEmailBody(String site, String confirmSignUpLink) throws IOException {
        String countryIso = this.context.getRequest().getLocale().getLanguage().toLowerCase();
        InputStream is = DefaultLoginAction.class.getResourceAsStream("/com/manydesigns/portofino/actions/user/confirmSignUpEmail." + countryIso + ".html");
        if (is == null) {
            is = DefaultLoginAction.class.getResourceAsStream("/com/manydesigns/portofino/actions/user/confirmSignUpEmail.en.html");
        }
        try (InputStream stream = is;){
            String template = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            String string = template.replace("$link", confirmSignUpLink).replace("$site", site);
            return string;
        }
    }

    @Path(value=":reset-password")
    @POST
    public void resetPassword(ResetPasswordRequest request) {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            logger.debug("Already logged in");
            return;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.checkPasswordStrength(request.newPassword, errorMessages)) {
            for (String current : errorMessages) {
                RequestMessages.addErrorMessage((String)current);
            }
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        PasswordResetToken token = new PasswordResetToken(request.token, request.newPassword);
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (AuthenticationException e) {
            String errMsg = ElementsThreadLocals.getText((String)"the.password.reset.link.is.no.longer.active", (Object[])new Object[0]);
            throw new WebApplicationException(errMsg, (Throwable)e, Response.Status.UNAUTHORIZED);
        }
    }

    protected void sendMail(String from, String to, String subject, String body) {
        if (this.mailQueue == null) {
            throw new UnsupportedOperationException("Mail queue is not enabled");
        }
        Email email = new Email();
        email.getRecipients().add(new Recipient(Recipient.Type.TO, to));
        email.setFrom(from);
        email.setSubject(subject);
        email.setHtmlBody(body);
        email.setTextBody(Jsoup.parse((String)body).text().toString());
        try {
            this.mailQueue.enqueue(email);
        }
        catch (QueueException e) {
            throw new RuntimeException(e);
        }
    }

    public String getApplicationName() {
        return this.portofinoConfiguration.getString("app.name");
    }

    protected boolean checkPasswordStrength(String password, List<String> errorMessages) {
        if (password == null) {
            errorMessages.add(ElementsThreadLocals.getText((String)"null.password", (Object[])new Object[0]));
            return false;
        }
        if (password.length() < 8) {
            errorMessages.add(ElementsThreadLocals.getText((String)"password.too.short", (Object[])new Object[]{8}));
            return false;
        }
        if (StringUtils.isAlpha((String)password)) {
            errorMessages.add(ElementsThreadLocals.getText((String)"password.only.letters", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Path(value="password")
    @PUT
    public void changePassword(@FormParam(value="oldPassword") String oldPassword, @FormParam(value="newPassword") String newPassword) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.checkPasswordStrength(newPassword, errorMessages)) {
            for (String current : errorMessages) {
                RequestMessages.addErrorMessage((String)current);
            }
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
        Subject subject = SecurityUtils.getSubject();
        Serializable principal = (Serializable)subject.getPrincipal();
        Serializable userId = portofinoRealm.getUserId(principal);
        try {
            portofinoRealm.changePassword(principal, oldPassword, newPassword);
            if (subject.isRemembered()) {
                UsernamePasswordToken usernamePasswordToken = new UsernamePasswordToken(this.getRememberedUserName(principal), newPassword);
                usernamePasswordToken.setRememberMe(true);
                try {
                    subject.login((AuthenticationToken)usernamePasswordToken);
                }
                catch (Exception e) {
                    logger.warn("User " + userId + " changed password but could not be subsequently authenticated", (Throwable)e);
                }
            }
        }
        catch (IncorrectCredentialsException e) {
            logger.warn("User {} password change: Incorrect credentials", (Object)userId);
            RequestMessages.addErrorMessage((String)ElementsThreadLocals.getText((String)"wrong.password", (Object[])new Object[0]));
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Password update failed for user " + userId, (Throwable)e);
            RequestMessages.addErrorMessage((String)ElementsThreadLocals.getText((String)"password.change.failed", (Object[])new Object[0]));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected String getRememberedUserName(Serializable principal) {
        PortofinoRealm realm = ShiroUtils.getPortofinoRealm();
        return realm.getUsername(principal);
    }

    @Path(value="user/classAccessor")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="The class accessor that describes the registration of a new user")
    public String describeNewUserClassAccessor() {
        ClassAccessor classAccessor = this.getNewUserClassAccessor();
        JSONStringer jsonStringer = new JSONStringer();
        ReflectionUtil.classAccessorToJson((ClassAccessor)classAccessor, (JSONStringer)jsonStringer);
        return jsonStringer.toString();
    }

    public ClassAccessor getNewUserClassAccessor() {
        PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
        return portofinoRealm.getSelfRegisteredUserClassAccessor();
    }

    @Path(value="user")
    @POST
    public void createUser() {
        Subject subject = SecurityUtils.getSubject();
        if (subject.getPrincipal() != null) {
            logger.debug("Already logged in");
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        String confirmationUrl = this.context.getRequest().getParameter("portofino:confirmationUrl");
        String siteNameOrAddress = this.context.getRequest().getParameter("portofino:siteNameOrAddress");
        PortofinoRealm portofinoRealm = ShiroUtils.getPortofinoRealm();
        Form signUpForm = this.setupSignUpForm();
        signUpForm.readFromRequest(this.context.getRequest());
        if (!signUpForm.validate()) {
            RequestMessages.addErrorMessage((String)ElementsThreadLocals.getText((String)"please.correct.the.errors.before.proceeding", (Object[])new Object[0]));
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.validateSignUpPassword(signUpForm, errorMessages)) {
            for (String current : errorMessages) {
                RequestMessages.addErrorMessage((String)current);
            }
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            Object user = portofinoRealm.getSelfRegisteredUserClassAccessor().newInstance();
            signUpForm.writeToObject(user);
            String[] tokenAndEmail = portofinoRealm.saveSelfRegisteredUser(user);
            String body = this.getConfirmSignUpEmailBody(siteNameOrAddress, confirmationUrl.replace("TOKEN", tokenAndEmail[0]));
            String from = this.portofinoConfiguration.getString("mail.from", "example@example.com");
            this.sendMail(from, tokenAndEmail[1], ElementsThreadLocals.getText((String)"confirm.signup", (Object[])new Object[0]), body);
        }
        catch (ExistingUserException e) {
            RequestMessages.addErrorMessage((String)ElementsThreadLocals.getText((String)"a.user.with.the.same.username.already.exists", (Object[])new Object[0]));
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Error during sign-up", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @Path(value="user/:confirm")
    @POST
    public void confirmUser(ConfirmUserRequest request) {
        SignUpToken token = new SignUpToken(request.token);
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (AuthenticationException e) {
            String errMsg = ElementsThreadLocals.getText((String)"the.sign.up.confirmation.link.is.no.longer.active", (Object[])new Object[0]);
            RequestMessages.addErrorMessage((String)errMsg);
            logger.warn(errMsg, (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    protected Form setupSignUpForm() {
        FormBuilder formBuilder = new FormBuilder(this.getNewUserClassAccessor()).configMode(Mode.CREATE).configReflectiveFields();
        return formBuilder.build();
    }

    protected boolean validateSignUpPassword(Form signUpForm, List<String> errorMessages) {
        return true;
    }

    @Path(value="{sessionId}")
    @DELETE
    @Deprecated
    public void logout(@PathParam(value="sessionId") String sessionId) {
        this.logout();
    }

    @DELETE
    public void logout() {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        logger.info("User logout");
    }

    public static class ConfirmUserRequest {
        public String token;
    }

    public static class ResetPasswordRequest {
        public String token;
        public String newPassword;
    }

    public static class ResetPasswordEmailRequest {
        public String email;
        public String siteNameOrAddress;
        public String loginPageUrl;
    }

    public static class LoginData {
        public String username;
        public String password;
    }
}

