/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest;

import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class Utilities {
    public static Response downloadBlob(Blob blob, BlobManager blobManager, HttpServletRequest request, Logger logger) {
        InputStream inputStream;
        long ifModifiedSince;
        if (blob == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (blob.getInputStream() == null) {
            try {
                blobManager.loadMetadata(blob);
            }
            catch (IOException e) {
                logger.error("Could not load blob", (Throwable)e);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        long contentLength = blob.getSize();
        String contentType = blob.getContentType();
        String fileName = blob.getFilename();
        long lastModified = blob.getCreateTimestamp().getMillis();
        if (request.getHeader("If-Modified-Since") != null && (ifModifiedSince = request.getDateHeader("If-Modified-Since")) >= lastModified) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        if (blob.getInputStream() == null) {
            try {
                inputStream = blobManager.openStream(blob);
            }
            catch (IOException e) {
                logger.error("Could not load blob", (Throwable)e);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        } else {
            inputStream = blob.getInputStream();
        }
        StreamingOutput streamingOutput = output -> {
            try (InputStream i = inputStream;){
                IOUtils.copyLarge((InputStream)i, (OutputStream)output);
            }
        };
        Response.ResponseBuilder responseBuilder = Response.ok((Object)streamingOutput).type(contentType).lastModified(new Date(lastModified)).header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        if (contentLength > 0L) {
            responseBuilder.header("Content-Length", (Object)contentLength);
        }
        return responseBuilder.build();
    }
}

