/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.spring.ConfigurationPropertySource;
import com.manydesigns.portofino.spring.PortofinoSpringConfiguration;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class PortofinoContextLoaderListener
extends ContextLoaderListener {
    public static final String RELOAD_CONTEXT_WHEN_SOURCES_CHANGE = "reloadContextWhenSourcesChange";
    public static final String PORTOFINO_CONTEXT_LOADER_LISTENER = PortofinoContextLoaderListener.class.getName();
    protected static final ThreadLocal<Boolean> reloadingUserContext = ThreadLocal.withInitial(() -> false);
    protected static final AtomicBoolean refreshing = new AtomicBoolean(true);
    private static final Logger logger = LoggerFactory.getLogger(PortofinoContextLoaderListener.class);
    protected final Set<Class<? extends Module>> moduleClasses = new HashSet<Class<? extends Module>>();
    protected ServletContext servletContext;
    protected ConfigurableWebApplicationContext parentContext;
    protected final ConfigurableWebApplicationContext bridgeContext = new AnnotationConfigWebApplicationContext();

    public PortofinoContextLoaderListener(Set<Class<?>> candidateModuleClasses) {
        for (Class<?> candidate : candidateModuleClasses) {
            if (candidate.isInterface() || Modifier.isAbstract(candidate.getModifiers()) || !Module.class.isAssignableFrom(candidate)) continue;
            this.moduleClasses.add(candidate.asSubclass(Module.class));
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            ElementsThreadLocals.setupDefaultElementsContext();
            this.servletContext = event.getServletContext();
            ElementsThreadLocals.setServletContext((ServletContext)this.servletContext);
            this.bridgeContext.setId("portofino-bridge");
            super.contextInitialized(event);
            this.servletContext.setAttribute(PORTOFINO_CONTEXT_LOADER_LISTENER, (Object)this);
            refreshing.set(false);
        }
        finally {
            ElementsThreadLocals.removeElementsContext();
        }
    }

    public static PortofinoContextLoaderListener get(ServletContext servletContext) {
        return (PortofinoContextLoaderListener)((Object)servletContext.getAttribute(PORTOFINO_CONTEXT_LOADER_LISTENER));
    }

    @NotNull
    protected ConfigurableWebApplicationContext createWebApplicationContext(@NotNull ServletContext sc) {
        if (this.parentContext == null) {
            this.setupParentContext();
            this.setupBridgeContext();
        }
        ConfigurableWebApplicationContext userContext = this.setupUserContext();
        this.bridgeContext.setParent((ApplicationContext)userContext);
        return this.bridgeContext;
    }

    protected void setupBridgeContext() {
        this.bridgeContext.addApplicationListener(event -> {
            if (event instanceof ContextClosedEvent) {
                assert (this.bridgeContext.getParent() != null);
                ((ConfigurableApplicationContext)this.bridgeContext.getParent()).close();
            }
        });
    }

    @NotNull
    protected ConfigurableWebApplicationContext setupUserContext() {
        AnnotationConfigWebApplicationContext userContext = new AnnotationConfigWebApplicationContext();
        userContext.setParent((ApplicationContext)this.parentContext);
        userContext.setId("portofino-user");
        userContext.addApplicationListener(event -> {
            if (event instanceof ContextClosedEvent) {
                if (reloadingUserContext.get().booleanValue()) {
                    logger.debug("Reloading user context, not closing parent");
                } else {
                    this.parentContext.close();
                }
            }
        });
        CodeBase codeBase = (CodeBase)this.servletContext.getAttribute("portofino.codebase");
        try {
            Class userConfigurationClass = codeBase.loadClass("SpringConfiguration");
            ((DefaultResourceLoader)userContext).setClassLoader(codeBase.asClassLoader());
            ((AnnotationConfigRegistry)userContext).register(new Class[]{userConfigurationClass});
            this.configureContextReload((ConfigurableWebApplicationContext)userContext, codeBase);
        }
        catch (Exception e) {
            logger.info("User-defined Spring configuration not found");
            logger.debug("Additional info", (Throwable)e);
        }
        return userContext;
    }

    protected void configureContextReload(ConfigurableWebApplicationContext userContext, CodeBase codeBase) {
        boolean reload;
        boolean bl = reload = !"false".equalsIgnoreCase(this.servletContext.getInitParameter(RELOAD_CONTEXT_WHEN_SOURCES_CHANGE));
        if (reload) {
            Disposable subscription = codeBase.getReloads().subscribe(c -> {
                if (this.isConfigurationClass((Class<?>)c)) {
                    if (refreshing.compareAndSet(false, true)) {
                        logger.info("Detected reload of " + c + ", refreshing the application context");
                        try {
                            this.refresh();
                        }
                        finally {
                            refreshing.set(false);
                        }
                    } else {
                        logger.warn("Detected reload of " + c + ", but the context is already refreshing");
                    }
                }
            });
            userContext.addApplicationListener(event -> {
                if (event instanceof ContextClosedEvent) {
                    subscription.dispose();
                }
            });
        }
    }

    protected void setupParentContext() {
        this.parentContext = new AnnotationConfigWebApplicationContext();
        this.parentContext.setId("portofino-parent");
        this.parentContext.setServletContext(this.servletContext);
        ConfigurableEnvironment environment = this.parentContext.getEnvironment();
        MutablePropertySources sources = environment.getPropertySources();
        org.apache.commons.configuration2.Configuration configuration = (org.apache.commons.configuration2.Configuration)this.servletContext.getAttribute("com.manydesigns.portofino.portofinoConfiguration");
        sources.addFirst((PropertySource)new ConfigurationPropertySource("portofino.properties", configuration));
        AnnotationConfigRegistry annotationConfig = (AnnotationConfigRegistry)this.parentContext;
        for (Class<? extends Module> moduleClass : this.moduleClasses) {
            annotationConfig.register(new Class[]{moduleClass});
        }
        annotationConfig.register(new Class[]{PortofinoSpringConfiguration.class});
        logger.info("Refreshing parent application context");
        this.parentContext.refresh();
    }

    protected void configureAndRefreshWebApplicationContext(ConfigurableWebApplicationContext bridgeContext, ServletContext sc) {
        ConfigurableWebApplicationContext userContext = (ConfigurableWebApplicationContext)bridgeContext.getParent();
        assert (userContext != null);
        logger.info("Configuring and refreshing user application context");
        super.configureAndRefreshWebApplicationContext(userContext, sc);
        logger.info("Refreshing bridge context");
        bridgeContext.refresh();
    }

    protected void customizeContext(@NotNull ServletContext sc, ConfigurableWebApplicationContext bridgeContext) {
        ElementsThreadLocals.setupDefaultElementsContext();
        ConfigurableWebApplicationContext userContext = (ConfigurableWebApplicationContext)bridgeContext.getParent();
        assert (userContext != null);
        super.customizeContext(sc, userContext);
    }

    public void refresh() {
        reloadingUserContext.set(true);
        try {
            ConfigurableWebApplicationContext userContext = (ConfigurableWebApplicationContext)this.bridgeContext.getParent();
            assert (userContext != null);
            userContext.close();
            this.createWebApplicationContext(this.servletContext);
            this.configureAndRefreshWebApplicationContext(this.bridgeContext, this.servletContext);
        }
        finally {
            reloadingUserContext.set(false);
        }
    }

    protected boolean isConfigurationClass(Class<?> c) {
        return c.getAnnotation(Component.class) != null || c.getAnnotation(Configuration.class) != null || c.getAnnotation(Repository.class) != null || c.getAnnotation(Service.class) != null;
    }

    protected ConfigurableWebApplicationContext createParentApplicationContext() {
        return new AnnotationConfigWebApplicationContext();
    }
}

