/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.shiro;

import com.manydesigns.portofino.shiro.ServletContainerToken;
import com.manydesigns.portofino.shiro.ShiroUtils;
import java.io.Serializable;
import java.security.Principal;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerSecurityFilter
extends PathMatchingFilter {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ServletContainerSecurityFilter.class);

    protected boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        Subject subject = SecurityUtils.getSubject();
        HttpServletRequest req = (HttpServletRequest)request;
        boolean shiroAuthenticated = subject.isAuthenticated();
        Principal containerPrincipal = this.getContainerPrincipal(req);
        boolean containerAuthenticated = containerPrincipal != null;
        logger.debug("User authenticated by Shiro? {} User authenticated by the container? {}", (Object)shiroAuthenticated, (Object)containerAuthenticated);
        if (!shiroAuthenticated && containerAuthenticated) {
            logger.debug("User is known to the servlet container, but not to Shiro, attempting programmatic login");
            try {
                subject.login((AuthenticationToken)new ServletContainerToken(req));
                Serializable userId = ShiroUtils.getUserId(SecurityUtils.getSubject());
                logger.info("User {} login", (Object)userId);
            }
            catch (AuthenticationException e) {
                HttpSession session = req.getSession(false);
                String attrName = ServletContainerSecurityFilter.class.getName() + ".shiroLoginFailedErrorLogged";
                String msg = "User " + containerPrincipal + " is known to the servlet container, but not to Shiro, and programmatic login failed!";
                if (session == null || session.getAttribute(attrName) == null) {
                    logger.error(msg, (Throwable)e);
                } else {
                    logger.debug(msg, (Throwable)e);
                }
                if (session != null) {
                    session.setAttribute(attrName, (Object)true);
                }
            }
        } else if (shiroAuthenticated && !containerAuthenticated) {
            logger.debug("User is authenticated to Shiro, but not to the servlet container; logging out of Shiro.");
            Serializable userId = ShiroUtils.getUserId(SecurityUtils.getSubject());
            subject.logout();
            logger.info("User {} logout", (Object)userId);
        }
        return true;
    }

    protected Principal getContainerPrincipal(HttpServletRequest req) {
        ServletRequest request;
        if (req instanceof ShiroHttpServletRequest && (request = ((ShiroHttpServletRequest)req).getRequest()) instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            return httpRequest.getUserPrincipal();
        }
        return req.getUserPrincipal();
    }
}

