/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.actions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.actions.ActionDescriptor;
import com.manydesigns.portofino.actions.AdditionalChild;
import com.manydesigns.portofino.resourceactions.ActionInstance;
import com.manydesigns.portofino.resourceactions.ActionNotActiveException;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.resourceactions.ResourceActionConfiguration;
import com.manydesigns.portofino.resourceactions.ResourceActionLogic;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ActionLogic {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ActionLogic.class);
    protected static final JAXBContext JAXB_CONTEXT;
    public static final String ACTION_DESCRIPTOR_CACHE_SIZE = "actionDescriptor.cache.size";
    public static final String ACTION_DESCRIPTOR_CACHE_CHECK_FREQUENCY = "actionDescriptor.cache.check.frequency";
    public static final String CONFIGURATION_CACHE_SIZE = "configuration.cache.size";
    public static final String CONFIGURATION_CACHE_CHECK_FREQUENCY = "configuration.cache.check.frequency";
    protected static LoadingCache<FileObject, FileCacheEntry<ActionDescriptor>> actionDescriptorCache;
    protected static LoadingCache<FileObject, ConfigurationCacheEntry> configurationCache;

    public static FileObject saveActionDescriptor(ActionInstance actionInstance) throws Exception {
        return ActionLogic.saveActionDescriptor(actionInstance.getDirectory(), actionInstance.getActionDescriptor());
    }

    public static FileObject saveActionDescriptor(FileObject directory, ActionDescriptor actionDescriptor) throws Exception {
        FileObject file = ActionLogic.getActionDescriptorFile(directory);
        Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        if (!file.exists()) {
            file.createFile();
        }
        try (OutputStream outputStream = file.getContent().getOutputStream();){
            marshaller.marshal((Object)actionDescriptor, outputStream);
            actionDescriptorCache.invalidate((Object)file);
        }
        return file;
    }

    public static void init(Configuration portofinoConfiguration) {
        int maxSize = portofinoConfiguration.getInt(ACTION_DESCRIPTOR_CACHE_SIZE, 1000);
        int refreshCheckFrequency = portofinoConfiguration.getInt(ACTION_DESCRIPTOR_CACHE_CHECK_FREQUENCY, 5);
        ActionLogic.initActionDescriptorCache(maxSize, refreshCheckFrequency);
        maxSize = portofinoConfiguration.getInt(CONFIGURATION_CACHE_SIZE, 1000);
        refreshCheckFrequency = portofinoConfiguration.getInt(CONFIGURATION_CACHE_CHECK_FREQUENCY, 5);
        ActionLogic.initConfigurationCache(maxSize, refreshCheckFrequency);
    }

    public static void mount(FileObject actionDirectory, String segment, String path) throws Exception {
        ActionDescriptor descriptor = ActionLogic.getActionDescriptor(actionDirectory);
        Optional<AdditionalChild> existing = descriptor.getAdditionalChildren().stream().filter(c -> c.getSegment().equals(segment)).findFirst();
        if (existing.isPresent()) {
            String existingPath = existing.get().getPath();
            if (!path.equals(existingPath)) {
                throw new IllegalArgumentException("Another path is already mounted at " + segment + ": " + existingPath);
            }
        } else {
            AdditionalChild child = new AdditionalChild();
            child.setSegment(segment);
            child.setPath(path);
            descriptor.getAdditionalChildren().add(child);
            ActionLogic.saveActionDescriptor(actionDirectory, descriptor);
        }
    }

    public static void mount(FileObject actionDirectory, String segment, Class<?> actionClass) throws Exception {
        ActionLogic.mount(actionDirectory, segment, "res:" + actionClass.getName().replace('.', '/') + ".class");
    }

    public static void mountPackage(FileObject actionDirectory, String segment, String packageName) throws Exception {
        ActionLogic.mount(actionDirectory, segment, "res:" + packageName.replace('.', '/'));
    }

    public static void mountPackage(FileObject actionDirectory, String segment, Package pkg) throws Exception {
        ActionLogic.mountPackage(actionDirectory, segment, pkg.getName());
    }

    public static void unmount(FileObject actionDirectory, String segment) throws Exception {
        ActionDescriptor descriptor = ActionLogic.getActionDescriptor(actionDirectory);
        Optional<AdditionalChild> existing = descriptor.getAdditionalChildren().stream().filter(c -> c.getSegment().equals(segment)).findFirst();
        if (existing.isPresent()) {
            descriptor.getAdditionalChildren().remove(existing.get());
            ActionLogic.saveActionDescriptor(actionDirectory, descriptor);
        }
    }

    public static void initActionDescriptorCache(int maxSize, int refreshCheckFrequency) {
        actionDescriptorCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).refreshAfterWrite((long)refreshCheckFrequency, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<FileObject, FileCacheEntry<ActionDescriptor>>(){

            public FileCacheEntry<ActionDescriptor> load(@NotNull FileObject key) throws Exception {
                return new FileCacheEntry<ActionDescriptor>(ActionLogic.loadActionDescriptor(key), key.getContent().getLastModifiedTime(), false);
            }

            public ListenableFuture<FileCacheEntry<ActionDescriptor>> reload(@NotNull FileObject key, FileCacheEntry<ActionDescriptor> oldValue) throws Exception {
                if (!key.exists()) {
                    return Futures.immediateFuture(new FileCacheEntry<Object>(null, 0L, true));
                }
                if (key.getContent().getLastModifiedTime() > oldValue.lastModified) {
                    try {
                        ActionDescriptor actionDescriptor = ActionLogic.loadActionDescriptor(key);
                        return Futures.immediateFuture(new FileCacheEntry<ActionDescriptor>(actionDescriptor, key.getContent().getLastModifiedTime(), false));
                    }
                    catch (Throwable t) {
                        logger.error("Could not reload cached actionDescriptor from " + key.getName().getPath() + ", removing from cache", t);
                        return Futures.immediateFuture(new FileCacheEntry<Object>(null, key.getContent().getLastModifiedTime(), true));
                    }
                }
                return Futures.immediateFuture(oldValue);
            }
        });
    }

    public static void initConfigurationCache(int maxSize, int refreshCheckFrequency) {
        configurationCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).refreshAfterWrite((long)refreshCheckFrequency, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<FileObject, ConfigurationCacheEntry>(){

            public ConfigurationCacheEntry load(FileObject key) {
                throw new UnsupportedOperationException();
            }

            public ListenableFuture<ConfigurationCacheEntry> reload(FileObject key, ConfigurationCacheEntry oldValue) throws Exception {
                if (!key.exists()) {
                    return Futures.immediateFuture((Object)new ConfigurationCacheEntry(null, null, 0L, true));
                }
                if (key.getContent().getLastModifiedTime() > oldValue.lastModified) {
                    try {
                        Object newConf = ActionLogic.loadConfiguration(key, oldValue.configurationClass);
                        return Futures.immediateFuture((Object)new ConfigurationCacheEntry(newConf, newConf.getClass(), key.getContent().getLastModifiedTime(), false));
                    }
                    catch (Throwable t) {
                        logger.error("Could not reload cached configuration from " + key.getName().getPath() + ", removing from cache", t);
                        return Futures.immediateFuture((Object)new ConfigurationCacheEntry(null, null, 0L, true));
                    }
                }
                return Futures.immediateFuture((Object)oldValue);
            }
        });
    }

    public static void clearConfigurationCache() {
        configurationCache.invalidateAll();
    }

    public static void clearConfigurationCache(Class configurationClass) {
        Set entries = configurationCache.asMap().entrySet();
        ArrayList keysToInvalidate = new ArrayList();
        for (Map.Entry entry : entries) {
            if (((ConfigurationCacheEntry)entry.getValue()).configurationClass != configurationClass) continue;
            keysToInvalidate.add(entry.getKey());
        }
        configurationCache.invalidateAll(keysToInvalidate);
    }

    protected static FileObject getActionDescriptorFile(FileObject directory) throws FileSystemException {
        return directory.resolveFile("action.xml");
    }

    public static ActionDescriptor loadActionDescriptor(FileObject key) throws Exception {
        try (InputStream fileInputStream = key.getContent().getInputStream();){
            ActionDescriptor action = ActionLogic.loadActionDescriptor(fileInputStream);
            action.init();
            ActionDescriptor actionDescriptor = action;
            return actionDescriptor;
        }
    }

    public static ActionDescriptor loadActionDescriptor(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
        return (ActionDescriptor)unmarshaller.unmarshal(inputStream);
    }

    public static ActionDescriptor getActionDescriptor(FileObject directory) throws ActionNotActiveException {
        try {
            FileObject actionDescriptorFile = ActionLogic.getActionDescriptorFile(directory);
            FileCacheEntry entry = (FileCacheEntry)actionDescriptorCache.get((Object)actionDescriptorFile);
            if (!entry.error) {
                return (ActionDescriptor)entry.object;
            }
            throw new ActionNotActiveException(directory.getName().getPath());
        }
        catch (Exception e) {
            throw new ActionNotActiveException(directory.getName().getPath(), e);
        }
    }

    public static FileObject saveConfiguration(FileObject directory, Object configuration) throws Exception {
        String configurationPackage = configuration.getClass().getPackage().getName();
        JAXBContext jaxbContext = JAXBContext.newInstance((String)configurationPackage);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileObject configurationFile = directory.resolveFile("configuration.xml");
        if (!configurationFile.exists()) {
            configurationFile.createFile();
        }
        try (OutputStream outputStream = configurationFile.getContent().getOutputStream();){
            marshaller.marshal(configuration, outputStream);
            configurationCache.invalidate((Object)configurationFile);
        }
        return configurationFile;
    }

    public static <T> T getConfiguration(FileObject configurationFile, Class<? extends T> configurationClass) throws Exception {
        if (configurationClass == null) {
            return null;
        }
        ConfigurationCacheEntry entry = (ConfigurationCacheEntry)configurationCache.getIfPresent((Object)configurationFile);
        if (entry == null || !configurationClass.isInstance(entry.object) || entry.error) {
            if (entry != null && entry.error) {
                logger.warn("Cached configuration for {} is in error state, forcing a reload", (Object)configurationFile.getName().getPath());
            } else if (entry != null && !configurationClass.isInstance(entry.object)) {
                logger.warn("Cached configuration for {} is an instance of the wrong class, forcing a reload", (Object)configurationFile.getName().getPath());
            }
            T configuration = ActionLogic.loadConfiguration(configurationFile, configurationClass);
            entry = new ConfigurationCacheEntry(configuration, configurationClass, configurationFile.getContent().getLastModifiedTime(), false);
            configurationCache.put((Object)configurationFile, (Object)entry);
        }
        return (T)entry.object;
    }

    public static <T> T loadConfiguration(FileObject configurationFile, Class<? extends T> configurationClass) throws Exception {
        if (configurationClass == null) {
            return null;
        }
        try (InputStream inputStream = configurationFile.getContent().getInputStream();){
            T t = ActionLogic.loadConfiguration(inputStream, configurationClass);
            return t;
        }
    }

    public static <T> T loadConfiguration(InputStream inputStream, Class<? extends T> configurationClass) throws Exception {
        if (configurationClass == null) {
            return null;
        }
        String configurationPackage = configurationClass.getPackage().getName();
        JAXBContext jaxbContext = JAXBContext.newInstance((String)configurationPackage);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(inputStream), configurationClass);
        Object configuration = element.getValue();
        if (!configurationClass.isInstance(configuration)) {
            logger.error("Invalid configuration: expected " + configurationClass + ", got " + configuration);
            return null;
        }
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)ElementsThreadLocals.getServletContext());
        webApplicationContext.getAutowireCapableBeanFactory().autowireBean(configuration);
        if (configuration instanceof ResourceActionConfiguration) {
            ((ResourceActionConfiguration)configuration).init();
        }
        return (T)configuration;
    }

    public static void configureResourceAction(ResourceAction resourceAction, ActionInstance actionInstance) {
        FileObject configurationFile;
        if (actionInstance.getConfiguration() != null) {
            logger.debug("ActionDescriptor instance {} is already configured", (Object)actionInstance);
            return;
        }
        try {
            configurationFile = actionInstance.getDirectory().resolveFile("configuration.xml");
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        Class<?> configurationClass = ResourceActionLogic.getConfigurationClass(resourceAction.getClass());
        try {
            Object configuration = ActionLogic.getConfiguration(configurationFile, configurationClass);
            actionInstance.setConfiguration(configuration);
        }
        catch (Throwable t) {
            logger.error("Couldn't load configuration from " + configurationFile.getName().getPath(), t);
        }
        resourceAction.setActionInstance(actionInstance);
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((String)ActionDescriptor.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new Error("Can't instantiate pages jaxb context", e);
        }
    }

    protected static class ConfigurationCacheEntry
    extends FileCacheEntry<Object> {
        public final Class<?> configurationClass;

        public ConfigurationCacheEntry(Object configuration, Class<?> configurationClass, long lastModified, boolean error) {
            super(configuration, lastModified, error);
            this.configurationClass = configurationClass;
        }
    }

    protected static class FileCacheEntry<T> {
        public final T object;
        public final long lastModified;
        public final boolean error;

        public FileCacheEntry(T object, long lastModified, boolean error) {
            this.object = object;
            this.lastModified = lastModified;
            this.error = error;
        }
    }
}

