/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.blobs.HierarchicalBlobManager;
import com.manydesigns.elements.blobs.SimpleBlobManager;
import com.manydesigns.elements.crypto.KeyManager;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PortofinoSpringConfiguration
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(PortofinoSpringConfiguration.class);
    public static final String APPLICATION_DIRECTORY = "com.manydesigns.portofino.application.directory";
    public static final String DEFAULT_BLOB_MANAGER = "defaultBlobManager";
    public static final String PORTOFINO_CONFIGURATION = "com.manydesigns.portofino.portofinoConfiguration";
    public static final String PORTOFINO_CONFIGURATION_FILE = "com.manydesigns.portofino.portofinoConfigurationFile";
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.portofinoConfiguration")
    org.apache.commons.configuration2.Configuration configuration;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.application.directory")
    FileObject applicationDirectory;

    @Bean(name={"defaultBlobManager"})
    public BlobManager getDefaultBlobManager() {
        File appBlobsDir = this.configuration.containsKey("blobs.dir.path") ? new File(this.configuration.getString("blobs.dir.path")) : new File(this.applicationDirectory.getName().getPath(), "blobs");
        logger.info("Blobs directory: " + appBlobsDir.getAbsolutePath());
        String metaFilenamePattern = "blob-{0}.properties";
        String dataFilenamePattern = "blob-{0}.data";
        File[] blobs = appBlobsDir.listFiles((dir, name) -> name.startsWith("blob-") && name.endsWith(".properties"));
        if (blobs == null || blobs.length == 0) {
            logger.info("Using hierarchical blob manager");
            return new HierarchicalBlobManager(appBlobsDir, metaFilenamePattern, dataFilenamePattern);
        }
        logger.warn("Blobs found directly under the blobs directory: using old style (pre-4.1.1) flat file blob manager");
        return new SimpleBlobManager(appBlobsDir, metaFilenamePattern, dataFilenamePattern);
    }

    @Bean
    public CacheResetListenerRegistry getCacheResetListenerRegistry() {
        return new CacheResetListenerRegistry();
    }

    public void afterPropertiesSet() throws Exception {
        if (!KeyManager.isActive()) {
            try {
                logger.info("Initializing KeyManager ");
                KeyManager.init((org.apache.commons.configuration2.Configuration)this.configuration);
            }
            catch (Exception e) {
                logger.error("Could not initialize KeyManager", (Throwable)e);
            }
        }
    }
}

