/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.servlets;

import com.manydesigns.elements.configuration.BeanLookup;
import com.manydesigns.elements.util.ElementsFileUtils;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.ResourceResolvers;
import com.manydesigns.portofino.dispatcher.web.WebDispatcherInitializer;
import com.manydesigns.portofino.rest.PortofinoRoot;
import com.manydesigns.portofino.servlets.ServerInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PortofinoDispatcherInitializer
extends WebDispatcherInitializer {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    public static final String PORTOFINO_CONFIGURATION_FILE_PROPERTY = "portofino.configuration.file";
    protected FileBasedConfigurationBuilder<PropertiesConfiguration> configurationFile;
    protected ServerInfo serverInfo;
    public static final Logger logger = LoggerFactory.getLogger(PortofinoDispatcherInitializer.class);

    public void initWithServletContext(ServletContext servletContext) {
        MDC.clear();
        this.serverInfo = new ServerInfo(servletContext);
        super.initWithServletContext(servletContext);
        servletContext.setAttribute("com.manydesigns.portofino.application.directory", (Object)this.applicationRoot);
        servletContext.setAttribute("com.manydesigns.portofino.portofinoConfiguration", (Object)this.configuration);
        servletContext.setAttribute("com.manydesigns.portofino.portofinoConfigurationFile", this.configurationFile);
        logger.info("Servlet API version is " + this.serverInfo.getServletApiVersion());
        if (this.serverInfo.getServletApiMajor() < 3) {
            String msg = "Servlet API version should be >= 3.0.";
            logger.warn(msg);
        }
    }

    protected String getApplicationDirectoryPath() {
        String applicationDirectoryPath = super.getApplicationDirectoryPath();
        if (applicationDirectoryPath != null) {
            ConfigurationInterpolator interpolator = new BaseConfiguration().getInterpolator();
            interpolator.registerLookups(this.getConfigurationLookups());
            return (String)interpolator.interpolate((Object)applicationDirectoryPath);
        }
        return null;
    }

    protected FileObject getCodeBaseRoot() throws FileSystemException {
        FileObject codeBaseRoot = this.applicationRoot.resolveFile("classes");
        String classpath = codeBaseRoot.getName().getPath();
        logger.info("Initializing codebase with classpath: " + classpath);
        ElementsFileUtils.ensureDirectoryExistsAndWarnIfNotWritable((File)new File(classpath));
        return codeBaseRoot;
    }

    protected PortofinoRoot getRoot(FileObject actionsDirectory, ResourceResolvers resourceResolver) throws Exception {
        return PortofinoRoot.get(actionsDirectory, (ResourceResolver)resourceResolver);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        MDC.clear();
    }

    protected void loadConfiguration() throws ConfigurationException, FileSystemException {
        FileObject localConfigurationFile;
        FileObject configurationFile = this.applicationRoot.resolveFile("portofino.properties");
        PropertiesBuilderParameters parameters = (PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setPrefixLookups(this.getConfigurationLookups())).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        String path = configurationFile.getName().getURI();
        parameters.setFileName(path);
        this.configurationFile = new Configurations().propertiesBuilder(path).configure(new BuilderParameters[]{parameters});
        this.configuration = (Configuration)this.configurationFile.getConfiguration();
        this.servletContext.setAttribute("portofino.configuration", (Object)this.configuration);
        String localConfigurationPath = null;
        try {
            localConfigurationPath = System.getProperty(PORTOFINO_CONFIGURATION_FILE_PROPERTY);
        }
        catch (SecurityException e) {
            logger.warn("Reading system properties is forbidden. Will read configuration file from standard location.", (Throwable)e);
        }
        String localConfigurationFromDeploymentDescriptor = this.servletContext.getInitParameter(PORTOFINO_CONFIGURATION_FILE_PROPERTY);
        if (localConfigurationFromDeploymentDescriptor != null) {
            logger.debug("Read configuration file location from deployment descriptor");
            localConfigurationPath = localConfigurationFromDeploymentDescriptor;
        }
        if (localConfigurationPath == null) {
            localConfigurationPath = this.configuration.getString("portofino-local.properties", this.applicationRoot.resolveFile("portofino-local.properties").getName().getURI());
        }
        if ((localConfigurationFile = VFS.getManager().resolveFile(localConfigurationPath)).exists()) {
            logger.info("Local configuration file: {}", (Object)localConfigurationFile);
            parameters.setFileName(localConfigurationPath);
            this.configurationFile = new Configurations().propertiesBuilder(localConfigurationPath).configure(new BuilderParameters[]{parameters});
            PropertiesConfiguration localConfiguration = (PropertiesConfiguration)this.configurationFile.getConfiguration();
            CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
            compositeConfiguration.setPrefixLookups(this.getConfigurationLookups());
            compositeConfiguration.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
            compositeConfiguration.addConfiguration((Configuration)localConfiguration, true);
            compositeConfiguration.addConfiguration(this.configuration);
            this.configuration = compositeConfiguration;
        } else {
            logger.info("No local configuration found at {}", (Object)localConfigurationPath);
        }
    }

    public Map<String, Lookup> getConfigurationLookups() {
        HashMap<String, Lookup> lookupMap = new HashMap<String, Lookup>();
        lookupMap.put("serverInfo", (Lookup)new BeanLookup((Object)this.serverInfo));
        lookupMap.put("applicationInfo", (Lookup)new BeanLookup((Object)new ApplicationInfo()));
        return lookupMap;
    }

    public FileBasedConfigurationBuilder<PropertiesConfiguration> getConfigurationFile() {
        return this.configurationFile;
    }

    public class ApplicationInfo {
        public String getApplicationDirectory() {
            return PortofinoDispatcherInitializer.this.applicationRoot.getName().getPath();
        }
    }
}

