/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.operations;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.portofino.operations.GuardType;
import com.manydesigns.portofino.operations.Operation;
import com.manydesigns.portofino.operations.annotations.Guard;
import com.manydesigns.portofino.operations.annotations.Guards;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import ognl.OgnlContext;
import org.jetbrains.annotations.Nullable;

public class Operations {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected static LoadingCache<Class, List<Operation>> operations = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Class, List<Operation>>(){

        public List<Operation> load(Class key) throws Exception {
            return Operations.computeOperationsForClass(key);
        }
    });

    public static List<Operation> getOperations(Class<?> someClass) {
        try {
            return (List)operations.get(someClass);
        }
        catch (ExecutionException e) {
            throw new Error(e);
        }
    }

    public static List<Operation> computeOperationsForClass(Class<?> someClass) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Method method : someClass.getMethods()) {
            Operation operation;
            if (method.isBridge() || method.isSynthetic() || (operation = Operations.getOperation(method)) == null) continue;
            operations.add(operation);
        }
        return operations;
    }

    public static Operation getOperation(Method method) {
        GET annotation;
        String path = "";
        Path pathAnn = method.getAnnotation(Path.class);
        if (pathAnn != null) {
            path = pathAnn.value();
        }
        if ((annotation = method.getAnnotation(GET.class)) == null) {
            annotation = method.getAnnotation(POST.class);
        }
        if (annotation == null) {
            annotation = method.getAnnotation(PUT.class);
        }
        if (annotation == null) {
            annotation = method.getAnnotation(DELETE.class);
        }
        if (annotation == null) {
            return null;
        }
        String signature = annotation.annotationType().getSimpleName() + " " + path;
        ArrayList<String> parameters = new ArrayList<String>();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] paramAnns;
            for (Annotation paramAnn : paramAnns = annotationArray[i]) {
                if (!(paramAnn instanceof QueryParam)) continue;
                parameters.add(((QueryParam)paramAnn).value());
            }
        }
        return new Operation(method, signature.trim(), parameters);
    }

    public static boolean doGuardsPass(Object actionBean, Method method) {
        return Operations.doGuardsPass(actionBean, method, null);
    }

    public static boolean doGuardsPass(Object actionBean, Method method, @Nullable GuardType type) {
        List<Guard> guards = Operations.getGuards(method, type);
        boolean pass = true;
        OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
        for (Guard guard : guards) {
            Object result = OgnlUtils.getValueQuietly((String)guard.test(), (Map)ognlContext, (Object)actionBean);
            pass &= result instanceof Boolean && (Boolean)result != false;
        }
        return pass;
    }

    public static List<Guard> getGuards(Method method, GuardType type) {
        ArrayList<Guard> guardList = new ArrayList<Guard>();
        Guard guard = method.getAnnotation(Guard.class);
        if (guard != null && (type == null || type == guard.type())) {
            guardList.add(guard);
        } else {
            Guards guards = method.getAnnotation(Guards.class);
            if (guards != null) {
                for (Guard g : guards.value()) {
                    if (type != null && type != g.type()) continue;
                    guardList.add(g);
                }
            }
        }
        return guardList;
    }
}

