/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.resourceactions;

import com.manydesigns.portofino.actions.ActionDescriptor;
import com.manydesigns.portofino.actions.Permissions;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionInstance {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final ActionDescriptor actionDescriptor;
    protected final FileObject directory;
    protected final List<String> parameters;
    protected final ActionInstance parent;
    protected final Class<? extends ResourceAction> actionClass;
    protected Object configuration;
    protected ResourceAction actionBean;
    protected boolean prepared;
    public static final String DETAIL = "_detail";
    public static final Logger logger = LoggerFactory.getLogger(ActionInstance.class);

    public ActionInstance(ActionInstance parent, FileObject directory, ActionDescriptor actionDescriptor, Class<? extends ResourceAction> actionClass) {
        this.parent = parent;
        this.directory = directory;
        this.actionDescriptor = actionDescriptor;
        this.actionClass = actionClass;
        this.parameters = new ArrayList<String>();
    }

    public ActionInstance copy() {
        ActionInstance actionInstance = new ActionInstance(this.parent, this.directory, this.actionDescriptor, this.actionClass);
        actionInstance.prepared = false;
        actionInstance.parameters.addAll(this.parameters);
        actionInstance.configuration = this.configuration;
        actionInstance.actionBean = this.actionBean;
        return actionInstance;
    }

    public ActionDescriptor getActionDescriptor() {
        return this.actionDescriptor;
    }

    public String getUrlSegment() {
        String segment = this.directory.getName().getBaseName();
        for (String param : this.parameters) {
            segment = segment + "/" + param;
        }
        return segment;
    }

    public String getPath() {
        if (this.getParent() == null) {
            return "";
        }
        return this.getParent().getPath() + "/" + this.getUrlSegment();
    }

    public FileObject getDirectory() {
        return this.directory;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
    }

    public Class<? extends ResourceAction> getActionClass() {
        return this.actionClass;
    }

    public ResourceAction getActionBean() {
        return this.actionBean;
    }

    public void setActionBean(ResourceAction actionBean) {
        this.actionBean = actionBean;
    }

    public ActionInstance getParent() {
        return this.parent;
    }

    public Permissions getPermissions() {
        return this.actionDescriptor.getPermissions();
    }

    public FileObject getChildPageDirectory(String name) {
        FileObject baseDir = this.getChildrenDirectory();
        try {
            return baseDir.resolveFile(name);
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public FileObject getChildrenDirectory() {
        FileObject baseDir = this.directory;
        if (!this.parameters.isEmpty()) {
            try {
                baseDir = baseDir.resolveFile(DETAIL);
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e);
            }
        }
        return baseDir;
    }

    public String getName() {
        return this.directory.getName().getBaseName();
    }
}

