/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.rest;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.messages.RequestMessages;
import com.manydesigns.portofino.cache.ControlsCache;
import com.manydesigns.portofino.operations.Guarded;
import com.manydesigns.portofino.operations.Operations;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.resourceactions.log.LogAccesses;
import com.manydesigns.portofino.security.SecurityFacade;
import com.manydesigns.portofino.security.noop.NoSecurity;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import ognl.OgnlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class PortofinoFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String ACCESS_LOGGER_NAME = "com.manydesigns.portofino.access";
    public static final String MESSAGE_HEADER = "X-Portofino-Message";
    public static final String PORTOFINO_API_VERSION_HEADER = "X-Portofino-API-Version";
    private static final Logger logger = LoggerFactory.getLogger(PortofinoFilter.class);
    private static final Logger accessLogger = LoggerFactory.getLogger((String)"com.manydesigns.portofino.access");
    public static final String PORTOFINO_API_VERSION = "5.2";
    @Context
    protected ResourceInfo resourceInfo;
    @Context
    protected HttpServletRequest request;
    @Context
    protected ServletContext servletContext;

    public void filter(ContainerRequestContext requestContext) {
        Method resourceMethod;
        UriInfo uriInfo = requestContext.getUriInfo();
        if (uriInfo.getMatchedResources().isEmpty()) {
            return;
        }
        Object resource = uriInfo.getMatchedResources().get(0);
        if (this.resourceInfo == null || this.resourceInfo.getResourceClass() == null) {
            return;
        }
        if (resource.getClass() != this.resourceInfo.getResourceClass()) {
            throw new RuntimeException("Inconsistency: matched resource is not of the right type, " + this.resourceInfo.getResourceClass());
        }
        logger.debug("Setting up logging MDC");
        MDC.clear();
        HttpServletRequest request = ElementsThreadLocals.getHttpServletRequest();
        if (request != null) {
            MDC.put((String)"req.requestURI", (String)request.getRequestURI());
        }
        if (resource instanceof ResourceAction) {
            ResourceAction resourceAction = (ResourceAction)resource;
            logger.debug("Retrieving user");
            Object userId = resourceAction.getSecurity().getUserId();
            if (userId != null) {
                MDC.put((String)"userId", (String)userId.toString());
            }
            OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
            ognlContext.put((Object)"securityUtils", resourceAction.getSecurity().getSecurityUtilsBean());
            resourceAction.prepareForExecution();
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        SecurityFacade facade = NoSecurity.AT_ALL;
        if (context != null) {
            try {
                facade = (SecurityFacade)context.getBean(SecurityFacade.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                logger.debug("No security facade found, using no-op", (Throwable)e);
            }
        }
        ((SecurityFacade)facade).checkWebResourceIsAccessible(requestContext, resource, this.resourceInfo.getResourceMethod());
        if (resource instanceof ResourceAction) {
            this.checkResourceActionInvocation(requestContext, (ResourceAction)resource);
        }
        if (PortofinoFilter.isAccessToBeLogged(resource, resourceMethod = this.resourceInfo.getResourceMethod())) {
            accessLogger.info(requestContext.getMethod() + " " + resourceMethod.getName() + ", queryString " + request.getQueryString());
        }
    }

    public static boolean isAccessToBeLogged(Object resource, Method handler) {
        if (resource != null) {
            LogAccesses annotation;
            Boolean log = null;
            Class<?> resourceClass = resource.getClass();
            if (handler != null && (annotation = handler.getAnnotation(LogAccesses.class)) != null) {
                log = annotation.value();
            }
            if (log == null) {
                annotation = resourceClass.getAnnotation(LogAccesses.class);
                log = annotation != null && annotation.value();
            }
            return log;
        }
        return false;
    }

    protected void addCacheHeaders(ContainerResponseContext responseContext) {
        if (this.resourceInfo.getResourceMethod() != null && this.resourceInfo.getResourceMethod().isAnnotationPresent(ControlsCache.class)) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Pragma", (Object)"no-cache");
        responseContext.getHeaders().putSingle((Object)"Expires", (Object)0);
        responseContext.getHeaders().add((Object)"Cache-Control", (Object)"no-cache");
        responseContext.getHeaders().add((Object)"Cache-Control", (Object)"no-store");
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        this.addCacheHeaders(responseContext);
        MultivaluedMap headers = responseContext.getHeaders();
        for (String message : RequestMessages.consumeErrorMessages()) {
            headers.add((Object)MESSAGE_HEADER, (Object)("error: " + message));
        }
        for (String message : RequestMessages.consumeWarningMessages()) {
            headers.add((Object)MESSAGE_HEADER, (Object)("warning: " + message));
        }
        for (String message : RequestMessages.consumeInfoMessages()) {
            headers.add((Object)MESSAGE_HEADER, (Object)("info: " + message));
        }
        if (!headers.containsKey((Object)PORTOFINO_API_VERSION_HEADER)) {
            headers.putSingle((Object)PORTOFINO_API_VERSION_HEADER, (Object)PORTOFINO_API_VERSION);
        }
    }

    protected void checkResourceActionInvocation(ContainerRequestContext requestContext, ResourceAction resourceAction) {
        Method handler = this.resourceInfo.getResourceMethod();
        HttpServletRequest request = ElementsThreadLocals.getHttpServletRequest();
        if (!resourceAction.getSecurity().isOperationAllowed(request, resourceAction.getActionInstance(), resourceAction, handler) || !resourceAction.isAccessible()) {
            logger.warn("Request not allowed: " + request.getMethod() + " " + request.getRequestURI());
            Response.Status status = resourceAction.getSecurity().isUserAuthenticated() ? Response.Status.FORBIDDEN : Response.Status.UNAUTHORIZED;
            requestContext.abortWith(Response.status((Response.Status)status).build());
        } else if (!Operations.doGuardsPass(resourceAction, handler)) {
            if (resourceAction instanceof Guarded) {
                Response response = ((Guarded)((Object)resourceAction)).guardsFailed(handler);
                requestContext.abortWith(response);
            } else {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"The action couldn't be invoked, a guard did not pass").build());
            }
        } else {
            logger.debug("Portofino-specific security check passed");
        }
    }
}

