/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.blobs.BlobManagerFactory;
import com.manydesigns.elements.blobs.DefaultBlobManagerFactory;
import com.manydesigns.elements.crypto.KeyManager;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.config.ConfigurationSource;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PortofinoSpringConfiguration
implements InitializingBean {
    public static final String APPLICATION_DIRECTORY = "com.manydesigns.portofino.application.directory";
    public static final String DEFAULT_BLOB_MANAGER = "defaultBlobManager";
    public static final String CONFIGURATION_SOURCE = "com.manydesigns.portofino.configuration";
    @Deprecated
    public static final String PORTOFINO_CONFIGURATION = "com.manydesigns.portofino.portofinoConfiguration";
    @Deprecated
    public static final String PORTOFINO_CONFIGURATION_FILE = "com.manydesigns.portofino.portofinoConfigurationFile";
    private static final Logger logger = LoggerFactory.getLogger(PortofinoSpringConfiguration.class);
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.configuration")
    ConfigurationSource configuration;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.application.directory")
    FileObject applicationDirectory;

    @Bean
    public DefaultBlobManagerFactory getStandardBlobManagerFactory() {
        return new DefaultBlobManagerFactory(this.configuration.getProperties(), this.applicationDirectory);
    }

    @Bean(name={"defaultBlobManager"})
    public BlobManager getDefaultBlobManager(@Autowired List<BlobManagerFactory> factories) {
        String type = this.configuration.getProperties().getString("blobmanager.type", "standard");
        return factories.stream().filter(f -> f.accept(type)).findFirst().map(BlobManagerFactory::getBlobManager).orElseThrow(() -> new RuntimeException("blobmanager.type not found in configuration"));
    }

    @Bean
    public CacheResetListenerRegistry getCacheResetListenerRegistry() {
        return new CacheResetListenerRegistry();
    }

    public void afterPropertiesSet() throws Exception {
        if (!KeyManager.isActive()) {
            logger.info("Initializing KeyManager ");
            KeyManager.init((org.apache.commons.configuration2.Configuration)this.configuration.getProperties());
        }
    }
}

