/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino;

import com.manydesigns.portofino.actions.ActionLogic;
import com.manydesigns.portofino.cache.CacheResetEvent;
import com.manydesigns.portofino.cache.CacheResetListener;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.config.ConfigurationSource;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import com.manydesigns.portofino.resourceactions.custom.CustomAction;
import com.manydesigns.portofino.resourceactions.form.FormAction;
import com.manydesigns.portofino.resourceactions.form.TableFormAction;
import com.manydesigns.portofino.resourceactions.registry.ActionRegistry;
import com.manydesigns.portofino.rest.PortofinoApplicationRoot;
import com.manydesigns.portofino.security.SecurityLogic;
import com.manydesigns.portofino.security.noop.login.NoOpLoginAction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;

public class ResourceActionsModule
implements Module {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    public static final String ACTIONS_DIRECTORY = "actionsDirectory";
    @Autowired
    public ServletContext servletContext;
    @Autowired
    public ConfigurationSource configuration;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.application.directory")
    public FileObject applicationDirectory;
    @Autowired
    public CodeBase codeBase;
    @Autowired
    public CacheResetListenerRegistry cacheResetListenerRegistry;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final Logger logger = LoggerFactory.getLogger(ResourceActionsModule.class);

    public String getModuleVersion() {
        return Module.getPortofinoVersion();
    }

    public String getName() {
        return "ResourceActions";
    }

    @PostConstruct
    public void init() throws Exception {
        logger.debug("Initializing dispatcher");
        ActionLogic.init(this.configuration.getProperties());
        FileObject actionsDirectory = this.getActionsDirectory(this.configuration, this.applicationDirectory);
        logger.info("Actions directory: " + actionsDirectory);
        if (this.configuration.getProperties().getBoolean("preload.actions", false)) {
            logger.info("Preloading actions");
            try {
                ResourceResolver resourceResolver = PortofinoApplicationRoot.getRootFactory().createRoot().getResourceResolver();
                this.preloadResourceActions(actionsDirectory, resourceResolver);
            }
            catch (Exception e) {
                logger.warn("Could not preload actions", (Throwable)e);
            }
        }
        if (this.configuration.getProperties().getBoolean("preload.classes", false)) {
            logger.info("Preloading Groovy classes");
            this.preloadClasses(this.codeBase.getRoot());
        }
        this.cacheResetListenerRegistry.getCacheResetListeners().add(new ConfigurationCacheResetListener());
        SecurityLogic.installLogin(actionsDirectory, this.configuration.getProperties(), NoOpLoginAction.class);
        this.status = ModuleStatus.STARTED;
    }

    @Bean
    public ActionRegistry getResourceActionRegistry() {
        logger.debug("Creating actions registry");
        ActionRegistry actionRegistry = new ActionRegistry();
        actionRegistry.register(CustomAction.class);
        actionRegistry.register(FormAction.class);
        actionRegistry.register(TableFormAction.class);
        return actionRegistry;
    }

    @Bean(name={"actionsDirectory"})
    public FileObject getActionsDirectory(@Autowired ConfigurationSource configuration, @Autowired @Qualifier(value="com.manydesigns.portofino.application.directory") FileObject applicationDirectory) throws FileSystemException {
        String actionsDirectory = configuration.getProperties().getString("portofino.actions.path", "actions");
        return applicationDirectory.resolveFile(actionsDirectory);
    }

    protected void preloadResourceActions(FileObject directory, ResourceResolver resourceResolver) throws FileSystemException {
        for (FileObject child : directory.getChildren()) {
            logger.debug("Preload resource action {}", (Object)child);
            if (child.getType() != FileType.FOLDER || child.equals(directory) || child.equals(directory.getParent())) continue;
            try {
                ((Class)resourceResolver.resolve(child, Class.class)).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                logger.warn("ResourceAction preload failed for actionDescriptor " + child.getName().getPath(), t);
            }
            this.preloadResourceActions(child, resourceResolver);
        }
    }

    protected void preloadClasses(FileObject directory) {
        try {
            for (FileObject file : directory.getChildren()) {
                logger.debug("visit {}", (Object)file);
                if (file.getType() == FileType.FOLDER) {
                    if (file.equals(directory) || file.equals(directory.getParent())) continue;
                    this.preloadClasses(file);
                    continue;
                }
                String extension = file.getName().getExtension();
                String className = this.codeBase.getRoot().getName().getRelativeName(file.getName());
                if (!StringUtils.isEmpty((CharSequence)extension)) {
                    className = className.substring(0, className.length() - extension.length() - 1);
                }
                logger.debug("Preloading " + className);
                try {
                    this.codeBase.loadClass(className);
                }
                catch (Throwable t) {
                    logger.warn("Class preload failed for " + className, t);
                }
            }
        }
        catch (FileSystemException e) {
            logger.warn("Could not preload classes under " + directory, (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.status = ModuleStatus.DESTROYED;
    }

    public ModuleStatus getStatus() {
        return this.status;
    }

    private static class ConfigurationCacheResetListener
    implements CacheResetListener {
        private ConfigurationCacheResetListener() {
        }

        @Override
        public void handleReset(CacheResetEvent e) {
            ActionLogic.clearConfigurationCache();
        }
    }
}

