/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.config;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSource {
    protected final Configuration configuration;
    protected final FileBasedConfigurationBuilder<PropertiesConfiguration> writableConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationSource.class);

    public ConfigurationSource(Configuration configuration, FileBasedConfigurationBuilder<PropertiesConfiguration> writableConfiguration) {
        this.configuration = configuration;
        this.writableConfiguration = writableConfiguration;
    }

    public Configuration getProperties() {
        return this.configuration;
    }

    public boolean isWritable() {
        return this.writableConfiguration != null;
    }

    public void save() throws ConfigurationException {
        if (!this.isWritable()) {
            throw new ConfigurationException("Not writable");
        }
        this.writableConfiguration.save();
        logger.info("Saved configuration file {}", (Object)this.writableConfiguration.getFileHandler().getFile().getAbsolutePath());
    }
}

