/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.i18n;

import com.manydesigns.portofino.i18n.ConfigurationResourceBundle;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleManager {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected LinkedList<String> searchPaths = new LinkedList();
    protected final ConcurrentMap<Locale, ConfigurationResourceBundle> resourceBundles = new ConcurrentHashMap<Locale, ConfigurationResourceBundle>();
    public static final Logger logger = LoggerFactory.getLogger(ResourceBundleManager.class);

    protected String getBundleFileName(String baseName, Locale locale) {
        return this.getBundleName(baseName, locale) + ".properties";
    }

    protected String getBundleName(String baseName, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (StringUtils.isBlank((String)language) && StringUtils.isBlank((String)country) && StringUtils.isBlank((String)variant)) {
            return baseName;
        }
        String name = baseName + "_";
        name = !StringUtils.isBlank((String)variant) ? name + language + "_" + country + "_" + variant : (!StringUtils.isBlank((String)country) ? name + language + "_" + country : name + language);
        return name;
    }

    public ConfigurationResourceBundle getBundle(Locale locale) {
        ConfigurationResourceBundle bundle = (ConfigurationResourceBundle)this.resourceBundles.get(locale);
        if (bundle == null) {
            CompositeConfiguration configuration = new CompositeConfiguration();
            Iterator<String> iterator = this.searchPaths.descendingIterator();
            while (iterator.hasNext()) {
                String path = iterator.next();
                int index = path.lastIndexOf(47) + 1;
                String basePath = path.substring(0, index);
                int suffixIndex = path.length() - ".properties".length();
                String resourceBundleBaseName = path.substring(index, suffixIndex);
                String bundleName = this.getBundleFileName(resourceBundleBaseName, locale);
                String bundleLocation = basePath + bundleName;
                URL bundleUrl = this.getBundleUrl(bundleLocation);
                try {
                    bundleUrl.openStream().close();
                }
                catch (IOException e) {
                    if (!StringUtils.isEmpty((String)locale.getCountry())) {
                        logger.debug("Couldn't load resource bundle for locale " + locale + " from " + basePath + ", trying with language-only locale", (Throwable)e);
                        bundle = this.getBundle(new Locale(locale.getLanguage()));
                        this.resourceBundles.put(locale, bundle);
                        return bundle;
                    }
                    logger.debug("Couldn't load resource bundle for locale " + locale + " from " + basePath + ", trying with default", (Throwable)e);
                    String defaultBundleName = basePath + resourceBundleBaseName + ".properties";
                    bundleUrl = this.getBundleUrl(defaultBundleName);
                }
                try {
                    Configuration conf = (Configuration)new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().fileBased().setURL(bundleUrl)}).getConfiguration();
                    configuration.addConfiguration(conf);
                }
                catch (ConfigurationException e) {
                    logger.debug("Couldn't load resource bundle from " + bundleUrl, (Throwable)e);
                }
            }
            bundle = new ConfigurationResourceBundle((Configuration)configuration, locale);
            this.resourceBundles.put(locale, bundle);
        }
        return bundle;
    }

    @NotNull
    protected URL getBundleUrl(String bundleLocation) {
        URL url;
        try {
            url = new URL(bundleLocation);
        }
        catch (MalformedURLException e) {
            try {
                url = new URL("file:" + bundleLocation);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Invalid bundle location: " + bundleLocation);
            }
        }
        return url;
    }

    public void addSearchPath(String searchPath) {
        if (this.searchPaths.contains(searchPath)) {
            logger.debug("Not adding search path: {}", (Object)searchPath);
            return;
        }
        logger.info("Adding search path: {}", (Object)searchPath);
        LinkedList<String> newSearchPaths = new LinkedList<String>(this.searchPaths);
        newSearchPaths.add(searchPath);
        this.searchPaths = newSearchPaths;
        this.resourceBundles.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " search paths: \n");
        for (String s : this.searchPaths) {
            sb.append(s + "\n");
        }
        return sb.toString();
    }
}

