/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.security;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.portofino.actions.Permissions;
import com.manydesigns.portofino.config.ConfigurationSource;
import com.manydesigns.portofino.operations.Operation;
import com.manydesigns.portofino.resourceactions.ActionInstance;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.security.RequiresPermissions;
import com.manydesigns.portofino.security.SecurityLogic;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.vfs2.FileObject;

public abstract class SecurityFacade {
    public abstract boolean hasPermissions(Configuration var1, Permissions var2, AccessLevel var3, String ... var4);

    public boolean hasPermissions(Configuration configuration, Permissions permissions, RequiresPermissions requiresPermissions) {
        return this.hasPermissions(configuration, permissions, requiresPermissions.level(), requiresPermissions.permissions());
    }

    public boolean hasPermissions(Configuration conf, ActionInstance instance, AccessLevel accessLevel, String ... permissions) {
        Permissions configuration = SecurityLogic.calculateActualPermissions(instance);
        return this.hasPermissions(conf, configuration, accessLevel, permissions);
    }

    public boolean hasPermissions(Configuration conf, Permissions permissions, Method handler, Class<?> theClass) {
        SecurityLogic.logger.debug("Checking action permissions");
        RequiresPermissions requiresPermissions = SecurityLogic.getRequiresPermissionsAnnotation(handler, theClass);
        if (requiresPermissions != null) {
            return this.hasPermissions(conf, permissions, requiresPermissions);
        }
        return true;
    }

    public boolean hasPermissions(Configuration conf, Method method, Class fallbackClass, ActionInstance actionInstance) {
        RequiresPermissions requiresPermissions = SecurityLogic.getRequiresPermissionsAnnotation(method, fallbackClass);
        if (requiresPermissions != null) {
            Permissions permissions = SecurityLogic.calculateActualPermissions(actionInstance);
            return this.hasPermissions(conf, permissions, requiresPermissions);
        }
        return true;
    }

    public boolean hasPermissions(Configuration conf, ActionInstance instance, Method handler) {
        SecurityLogic.logger.debug("Checking action permissions");
        Class<? extends ResourceAction> theClass = instance.getActionClass();
        RequiresPermissions requiresPermissions = SecurityLogic.getRequiresPermissionsAnnotation(handler, theClass);
        if (requiresPermissions != null) {
            AccessLevel accessLevel = requiresPermissions.level();
            String[] permissions = requiresPermissions.permissions();
            return this.hasPermissions(conf, instance, accessLevel, permissions);
        }
        return true;
    }

    public boolean isOperationAllowed(ResourceAction action, Configuration configuration, HttpServletRequest request, Operation operation, Method handler) {
        boolean isAdmin = this.isAdministrator((ServletRequest)request);
        return isAdmin || (action.getActionInstance() == null || this.hasPermissions(configuration, operation.getMethod(), action.getClass(), action.getActionInstance())) && SecurityLogic.satisfiesRequiresAdministrator(action, handler, false);
    }

    public boolean isOperationAllowed(HttpServletRequest request, ActionInstance actionInstance, ResourceAction resourceAction, Method handler) {
        boolean isNotAdmin;
        if (!SecurityLogic.satisfiesRequiresAdministrator(resourceAction, handler, this.isAdministrator((ServletRequest)request))) {
            return false;
        }
        SecurityLogic.logger.debug("Checking actionDescriptor permissions");
        boolean bl = isNotAdmin = !this.isAdministrator((ServletRequest)request);
        if (isNotAdmin) {
            boolean allowed;
            String resource;
            ServletContext servletContext = request.getServletContext();
            ConfigurationSource configuration = (ConfigurationSource)servletContext.getAttribute("com.manydesigns.portofino.configuration");
            if (actionInstance != null) {
                SecurityLogic.logger.debug("The protected resource is a actionDescriptor action");
                resource = actionInstance.getPath();
                allowed = this.hasPermissions(configuration.getProperties(), actionInstance, handler);
            } else {
                SecurityLogic.logger.debug("The protected resource is a regular JAX-RS resource");
                resource = request.getRequestURI();
                Permissions permissions = new Permissions();
                allowed = this.hasPermissions(configuration.getProperties(), permissions, handler, resourceAction.getClass());
            }
            if (!allowed) {
                SecurityLogic.logger.info("Access to {} is forbidden", (Object)resource);
                return false;
            }
        }
        return true;
    }

    public boolean isAdministrator(ServletRequest request) {
        ServletContext servletContext = ElementsThreadLocals.getServletContext();
        ConfigurationSource conf = (ConfigurationSource)servletContext.getAttribute("com.manydesigns.portofino.configuration");
        return this.isAdministrator(conf.getProperties());
    }

    public abstract boolean isAdministrator(Configuration var1);

    public abstract Object getSecurityUtilsBean();

    public abstract Object getUserId();

    public abstract Set<String> getGroups();

    public abstract void setup(FileObject var1, String var2, String var3) throws IOException;

    public abstract boolean isUserAuthenticated();

    public abstract Map getUsers();

    public abstract void checkWebResourceIsAccessible(ContainerRequestContext var1, Object var2, Method var3);
}

