/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.security;

import com.manydesigns.portofino.actions.ActionDescriptor;
import com.manydesigns.portofino.actions.ActionLogic;
import com.manydesigns.portofino.actions.Permissions;
import com.manydesigns.portofino.resourceactions.ActionInstance;
import com.manydesigns.portofino.resourceactions.ResourceAction;
import com.manydesigns.portofino.security.AccessLevel;
import com.manydesigns.portofino.security.RequiresAdministrator;
import com.manydesigns.portofino.security.RequiresPermissions;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.vfs2.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityLogic {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String GROUP_ALL = "group.all";
    public static final String GROUP_ANONYMOUS = "group.anonymous";
    public static final String GROUP_REGISTERED = "group.registered";
    public static final String GROUP_ADMINISTRATORS = "group.administrators";
    public static final String GROUP_ALL_DEFAULT = "all";
    public static final String GROUP_ANONYMOUS_DEFAULT = "anonymous";
    public static final String GROUP_REGISTERED_DEFAULT = "registered";
    public static final String GROUP_ADMINISTRATORS_DEFAULT = "administrators";
    public static final Logger logger = LoggerFactory.getLogger(SecurityLogic.class);

    public static Permissions calculateActualPermissions(ActionInstance instance) {
        ArrayList<ActionDescriptor> actionDescriptors = new ArrayList<ActionDescriptor>();
        while (instance != null) {
            actionDescriptors.add(0, instance.getActionDescriptor());
            instance = instance.getParent();
        }
        return SecurityLogic.calculateActualPermissions(new Permissions(), actionDescriptors);
    }

    public static Permissions calculateActualPermissions(Permissions basePermissions, List<ActionDescriptor> actionDescriptors) {
        Permissions result = new Permissions();
        Map<String, AccessLevel> resultLevels = result.getActualLevels();
        resultLevels.putAll(basePermissions.getActualLevels());
        for (ActionDescriptor current : actionDescriptors) {
            Permissions currentPerms = current.getPermissions();
            Map<String, AccessLevel> currentLevels = currentPerms.getActualLevels();
            for (Map.Entry<String, AccessLevel> entry : currentLevels.entrySet()) {
                String currentGroup = entry.getKey();
                AccessLevel currentLevel = entry.getValue();
                AccessLevel resultLevel = resultLevels.get(currentGroup);
                if (resultLevel == AccessLevel.DENY || currentLevel == null) continue;
                resultLevels.put(currentGroup, currentLevel);
            }
        }
        if (actionDescriptors.size() > 0) {
            ActionDescriptor lastAction = actionDescriptors.get(actionDescriptors.size() - 1);
            Map<String, Set<String>> lastPermissions = lastAction.getPermissions().getActualPermissions();
            result.getActualPermissions().putAll(lastPermissions);
        } else {
            result.getActualPermissions().putAll(basePermissions.getActualPermissions());
        }
        return result;
    }

    public static RequiresPermissions getRequiresPermissionsAnnotation(Method handler, Class<?> theClass) {
        RequiresPermissions requiresPermissions = handler.getAnnotation(RequiresPermissions.class);
        if (requiresPermissions != null) {
            logger.debug("Action method requires specific permissions: {}", (Object)handler);
        } else {
            requiresPermissions = theClass.getAnnotation(RequiresPermissions.class);
            if (requiresPermissions != null) {
                logger.debug("Action class requires specific permissions: {}", theClass);
            }
        }
        return requiresPermissions;
    }

    public static boolean satisfiesRequiresAdministrator(Object actionBean, Method handler, boolean isAdmin) {
        boolean doesNotSatisfy;
        logger.debug("Checking if action or method required administrator");
        boolean requiresAdministrator = false;
        if (handler.isAnnotationPresent(RequiresAdministrator.class)) {
            logger.debug("Action method requires administrator: {}", (Object)handler);
            requiresAdministrator = true;
        } else {
            for (Class<?> actionClass = actionBean.getClass(); actionClass != null; actionClass = actionClass.getSuperclass()) {
                if (!actionClass.isAnnotationPresent(RequiresAdministrator.class)) continue;
                logger.debug("Action class requires administrator: {}", actionClass);
                requiresAdministrator = true;
                break;
            }
        }
        boolean bl = doesNotSatisfy = requiresAdministrator && !isAdmin;
        if (doesNotSatisfy) {
            logger.debug("User is not an administrator");
            return false;
        }
        return true;
    }

    public static String getAdministratorsGroup(Configuration conf) {
        return conf.getString(GROUP_ADMINISTRATORS, GROUP_ADMINISTRATORS_DEFAULT);
    }

    public static String getAllGroup(Configuration conf) {
        return conf.getString(GROUP_ALL, GROUP_ALL_DEFAULT);
    }

    public static String getAnonymousGroup(Configuration conf) {
        return conf.getString(GROUP_ANONYMOUS, GROUP_ANONYMOUS_DEFAULT);
    }

    public static String getRegisteredGroup(Configuration conf) {
        return conf.getString(GROUP_REGISTERED, GROUP_REGISTERED_DEFAULT);
    }

    public static void installLogin(FileObject actionsDirectory, Configuration configuration, Class<? extends ResourceAction> fallbackLoginClass) throws Exception {
        String relLoginPath = configuration.getString("login.path");
        String loginPath = relLoginPath != null ? (relLoginPath.startsWith("/") ? "file:" + relLoginPath.substring(1) : "file:" + relLoginPath) : "res:" + fallbackLoginClass.getPackage().getName().replace('.', '/');
        ActionLogic.unmount(actionsDirectory, ":auth");
        ActionLogic.mount(actionsDirectory, ":auth", loginPath);
    }
}

