/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import com.manydesigns.portofino.config.ConfigurationSource;
import com.manydesigns.portofino.i18n.I18nUtils;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.servlets.ServerInfo;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.vfs2.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PortofinoWebSpringConfiguration
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(PortofinoWebSpringConfiguration.class);
    protected ServletContext servletContext;
    protected FileObject applicationDirectory;
    protected org.apache.commons.configuration2.Configuration configuration;
    protected static final String SEPARATOR = "--------------------------------------------------------------------------------";

    @Bean
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Autowired
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Autowired
    @Qualifier(value="com.manydesigns.portofino.application.directory")
    public void setApplicationDirectory(FileObject applicationDirectory) {
        this.applicationDirectory = applicationDirectory;
    }

    @Autowired
    public void setConfiguration(ConfigurationSource configuration) {
        this.configuration = configuration.getProperties();
    }

    public void afterPropertiesSet() throws Exception {
        String portofinoVersion;
        String versionCheckUrl;
        I18nUtils.setupResourceBundleManager(this.applicationDirectory, this.servletContext);
        String encoding = this.configuration.getString("url.encoding", "UTF-8");
        logger.info("URL character encoding is set to " + encoding + ". Make sure the web server uses the same encoding to parse URLs.");
        if (!Charset.isSupported(encoding)) {
            logger.error("The encoding is not supported by the JVM!");
        }
        if (!"off".equalsIgnoreCase(versionCheckUrl = this.configuration.getString("portofino.version.check.url", "https://portofino.manydesigns.com/version-check.jsp"))) {
            portofinoVersion = Module.getPortofinoVersion();
            try {
                this.checkForNewVersion(portofinoVersion, versionCheckUrl);
            }
            catch (Throwable t) {
                logger.warn("Version check failed unexpectedly", t);
            }
        }
        portofinoVersion = Module.getPortofinoVersion();
        String lineSeparator = System.getProperty("line.separator", "\n");
        ServerInfo serverInfo = new ServerInfo(this.servletContext);
        logger.info(lineSeparator + SEPARATOR + lineSeparator + "--- ManyDesigns Portofino " + portofinoVersion + " started successfully" + lineSeparator + "--- Context path: {}" + lineSeparator + "--- Real path: {}" + lineSeparator + "--- Visit https://portofino.manydesigns.com for news, documentation, issue tracker, community forums, commercial support!" + lineSeparator + SEPARATOR, (Object)serverInfo.getContextPath(), (Object)serverInfo.getRealPath());
    }

    protected void checkForNewVersion(String portofinoVersion, String versionCheckUrl) {
        String SEPARATOR = SEPARATOR;
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(versionCheckUrl).queryParam("version", new Object[]{portofinoVersion});
        Future responseFuture = target.request().async().get();
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                Response response = (Response)responseFuture.get();
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    String latestVersion = ((String)response.readEntity(String.class)).trim();
                    if (Objects.equals(portofinoVersion, latestVersion)) {
                        logger.info("Your installation of Portofino is up-to-date");
                    } else {
                        String lineSeparator = System.getProperty("line.separator", "\n");
                        logger.info(lineSeparator + SEPARATOR + lineSeparator + "A new version of Portofino is available: " + latestVersion + lineSeparator + SEPARATOR);
                    }
                } else {
                    logger.info("Version check failed: " + response.getStatus());
                }
                String message = response.getHeaderString("X-Message");
                if (message != null) {
                    logger.info(message);
                }
            }
            catch (Exception e) {
                logger.info("Could not check for new version: " + e.getMessage());
                logger.debug("Additional information", (Throwable)e);
            }
        });
    }
}

