/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.spring;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileSystem;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;

public class SpringBootResourceFileProvider
extends ResourceFileProvider {
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName fileName = baseFile != null ? this.parseUri(baseFile.getName(), uri) : this.parseUri(null, uri);
        String resourceName = fileName.getPath();
        ClassLoader classLoader = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        FileSystemException.requireNonNull((Object)classLoader, (String)"vfs.provider.url/badly-formed-uri.error", (Object[])new Object[]{uri});
        URL url = classLoader.getResource(resourceName);
        if (url != null) {
            return this.getContext().getFileSystemManager().resolveFile(this.fixNestedURI(url.toExternalForm()));
        }
        return this.noFile(resourceName);
    }

    private FileObject noFile(String name) {
        AbstractFileName fileName = new AbstractFileName("res", name, FileType.IMAGINARY){

            public FileName createName(String absolutePath, FileType fileType) {
                return null;
            }

            protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
            }
        };
        return new AbstractFileObject<RamFileSystem>(fileName, new RamFileSystem((FileName)fileName, new FileSystemOptions()){}){

            protected long doGetContentSize() throws Exception {
                return 0L;
            }

            protected FileType doGetType() throws Exception {
                return FileType.IMAGINARY;
            }

            protected String[] doListChildren() throws Exception {
                return new String[0];
            }
        };
    }

    public String fixNestedURI(String uri) {
        int bang = uri.indexOf(33);
        if (bang < 0 || !uri.startsWith("jar:file:")) {
            return uri;
        }
        StringBuilder prefix = new StringBuilder();
        Matcher matcher = Pattern.compile("[.]jar!").matcher(uri);
        if (matcher.find()) {
            while (matcher.find()) {
                prefix.append("jar:");
            }
        }
        matcher = Pattern.compile("([^.][^j][^a][^r])!").matcher(uri);
        return prefix + matcher.replaceAll("$1");
    }
}

