/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.swagger;

import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.RootFactory;
import com.manydesigns.portofino.dispatcher.WithParameters;
import com.manydesigns.portofino.dispatcher.visitor.DepthFirstVisitor;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.jaxrs2.ReaderListener;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.container.ResourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentedApiRoot
implements ReaderListener {
    protected static final Logger logger = LoggerFactory.getLogger(DocumentedApiRoot.class);
    protected static RootFactory rootFactory;

    public static void setRootFactory(RootFactory rootFactory) {
        DocumentedApiRoot.rootFactory = rootFactory;
    }

    public static RootFactory getRootFactory() {
        return rootFactory;
    }

    public void beforeScan(Reader reader, OpenAPI openAPI) {
    }

    public void afterScan(Reader reader, OpenAPI openAPI) {
        SubResourceReader subResourceReader = this.getSubResourceReader(reader);
        try {
            Resource root = rootFactory.createRoot();
            root.setResourceContext(this.getResourceContext());
            new DepthFirstVisitor(node -> {
                try {
                    OpenAPI subApi = subResourceReader.readSubResource(node);
                    openAPI.getPaths().putAll((Map)subApi.getPaths());
                }
                catch (Exception e) {
                    logger.error("Could not read node at " + node.getLocation(), (Throwable)e);
                }
            }).visit(root);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected SubResourceReader getSubResourceReader(Reader reader) {
        return new SubResourceReader(reader);
    }

    protected ResourceContext getResourceContext() {
        return new DummyResourceContext();
    }

    public static class DummyResourceContext
    implements ResourceContext {
        public <T> T getResource(Class<T> resourceClass) {
            try {
                return this.initResource(resourceClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                logger.warn("Could not create resource for Swagger", (Throwable)e);
                return null;
            }
        }

        public <T> T initResource(T resource) {
            if (resource instanceof Resource) {
                ((Resource)resource).setResourceContext(this);
            }
            return resource;
        }
    }

    protected static class SubResourceReader
    extends Reader {
        public SubResourceReader(Reader reader) {
            super(reader.getOpenAPI());
        }

        public OpenAPI readSubResource(Resource resource) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            String path = this.calculateResourcePath(resource, parameters);
            return this.read(resource.getClass(), path, null, true, null, null, new HashSet(), parameters, new HashSet());
        }

        public String calculateResourcePath(Resource resource, ArrayList<Parameter> parameters) {
            String path;
            if (resource.getParent() != null) {
                path = this.calculateResourcePath(resource.getParent(), parameters);
                path = path + "/" + resource.getSegment();
            } else {
                path = "";
            }
            if (resource instanceof WithParameters) {
                WithParameters wp = (WithParameters)((Object)resource);
                for (int i = 0; i < wp.getParameters().size(); ++i) {
                    String name = wp.getParameterName(i);
                    path = path + "/{" + name + "}";
                    PathParameter parameter = new PathParameter();
                    parameter.setName(name);
                    parameter.setRequired(Boolean.valueOf(true));
                    parameters.add((Parameter)parameter);
                }
            }
            return path;
        }
    }
}

