/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher;

import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.security.ResourcePermissions;
import com.manydesigns.portofino.dispatcher.security.SecureResource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResource
implements SecureResource {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractResource.class);
    protected FileObject location;
    protected Resource parent;
    protected String segment;
    @Context
    protected ResourceContext resourceContext;

    @Override
    public FileObject getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(FileObject location) {
        this.location = location;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.getParent().getResourceResolver();
    }

    @Override
    public Resource getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Resource parent) {
        this.parent = parent;
    }

    @Override
    public String getPath() {
        return this.parent.getPath() + this.getSegment() + "/";
    }

    @Override
    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
    }

    @Override
    @Path(value="{pathSegment}")
    public Object consumePathSegment(@PathParam(value="pathSegment") String pathSegment) {
        try {
            FileObject child = this.getChildLocation(pathSegment);
            return this.consumePathSegment(pathSegment, child, this.getResourceResolver());
        }
        catch (FileSystemException e) {
            logger.error("Could not access child: " + pathSegment, (Throwable)e);
            throw new WebApplicationException(404);
        }
    }

    protected FileObject getChildLocation(String pathSegment) throws FileSystemException {
        FileObject child = this.getChildrenLocation().resolveFile(pathSegment);
        this.checkChildLocation(pathSegment, child);
        return child;
    }

    protected void checkChildLocation(String pathSegment, FileObject child) throws FileSystemException {
        if (child == null) {
            return;
        }
        if (!child.getParent().equals(this.getChildrenLocation())) {
            throw new IllegalArgumentException("Path segment " + pathSegment + " results in a path that is not a child of the current node and for security reasons this is forbidden.");
        }
    }

    protected Object consumePathSegment(String pathSegment, FileObject resourceLocation, ResourceResolver resourceResolver) {
        if (resourceLocation != null) {
            Object subResource;
            try {
                subResource = this.getSubResource(resourceLocation, pathSegment, resourceResolver);
            }
            catch (Exception e) {
                logger.error("Could not resolve sub resource", (Throwable)e);
                throw new WebApplicationException(500);
            }
            if (subResource == null) {
                throw new WebApplicationException(404);
            }
            return subResource;
        }
        logger.debug("Child file not found: {} {}", (Object)this.location, (Object)pathSegment);
        throw new WebApplicationException(404);
    }

    @Override
    public Object getSubResource(String subResourceName) throws Exception {
        FileObject subResourceLocation = this.getChildLocation(subResourceName);
        return this.getSubResource(subResourceLocation, subResourceName, this.getResourceResolver());
    }

    public Object getSubResource(FileObject resourceLocation, String segment, ResourceResolver resourceResolver) throws Exception {
        Class subResourceClass = resourceResolver.resolve(resourceLocation, Class.class);
        if (subResourceClass == null) {
            logger.debug("Subresource could not be resolved");
            return null;
        }
        return this.createSubResource(subResourceClass, resourceLocation, segment);
    }

    protected Object createSubResource(Class<?> subResourceClass, FileObject location, String segment) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        return this.initSubResource(subResourceClass.getConstructor(new Class[0]).newInstance(new Object[0]), location, segment);
    }

    protected Object initSubResource(Object resource, FileObject location, String segment) {
        if (resource instanceof Resource) {
            Resource subResource = (Resource)resource;
            subResource.setParent(this);
            subResource.setLocation(location);
            subResource.setSegment(segment);
            this.initGenericResource(resource);
            this.initSubResource(subResource);
            return subResource.init();
        }
        this.initGenericResource(resource);
        return resource;
    }

    protected void initSubResource(Resource resource) {
        this.initSubResource((Object)resource);
    }

    protected void initSubResource(Object resource) {
    }

    protected void initGenericResource(Object resource) {
        this.resourceContext.initResource(resource);
    }

    public Map<String, Object> describe() {
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("superclass", this.getClass().getSuperclass().getName());
        description.put("class", this.getClass().getName());
        description.put("path", this.getPath());
        description.put("children", this.getSubResources());
        this.describe(description);
        return description;
    }

    protected void describe(Map<String, Object> description) {
    }

    @Path(value=":description")
    @Produces(value={"application/json"})
    @GET
    public Map<String, Object> getJSONDescription() {
        return this.describe();
    }

    public FileObject getChildrenLocation() throws FileSystemException {
        return this.location;
    }

    @Override
    public Collection<String> getSubResources() {
        try {
            FileObject[] children;
            ArrayList<String> subResources = new ArrayList<String>();
            FileObject childrenLocation = this.getChildrenLocation();
            if (childrenLocation == null || !childrenLocation.exists() || childrenLocation.getType() != FileType.FOLDER) {
                return subResources;
            }
            for (FileObject child : children = childrenLocation.getChildren()) {
                if (child.getType() != FileType.FOLDER) continue;
                subResources.add(child.getName().getBaseName());
            }
            return subResources;
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSegment() {
        return this.segment;
    }

    @Override
    public void setSegment(String segment) {
        this.segment = segment;
    }

    @Override
    public ResourcePermissions getPermissions() {
        try {
            Map permissions = this.getResourceResolver().resolve(this.location, "permissions", Map.class);
            if (permissions != null) {
                Map allow = (Map)permissions.get("allow");
                Map deny = (Map)permissions.get("deny");
                return new ResourcePermissions(this, this.translatePermissions(allow), this.translatePermissions(deny));
            }
            return this.getEmptyResourcePermissions();
        }
        catch (Exception e) {
            logger.error("Could not load permissions for " + this.location, (Throwable)e);
            return this.getEmptyResourcePermissions();
        }
    }

    protected Map<String, List<Permission>> translatePermissions(Map<String, List<String>> stringMap) {
        if (stringMap == null) {
            return null;
        }
        HashMap<String, List<Permission>> permissionMap = new HashMap<String, List<Permission>>();
        for (Map.Entry<String, List<String>> entry : stringMap.entrySet()) {
            ArrayList<WildcardPermission> permissionList = new ArrayList<WildcardPermission>(entry.getValue().size());
            for (String perm : entry.getValue()) {
                permissionList.add(new WildcardPermission(perm));
            }
            permissionMap.put(entry.getKey(), permissionList);
        }
        return permissionMap;
    }

    protected ResourcePermissions getEmptyResourcePermissions() {
        Map<String, List<Permission>> emptyMap = Collections.emptyMap();
        return new ResourcePermissions(this, emptyMap, emptyMap);
    }

    @Override
    public Object init() {
        return this;
    }
}

