/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.web;

import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.JavaCodeBase;
import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import com.manydesigns.portofino.dispatcher.Root;
import com.manydesigns.portofino.dispatcher.resolvers.CachingResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.JavaResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.ResourceResolvers;
import com.manydesigns.portofino.dispatcher.swagger.DocumentedApiRoot;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherInitializer
implements ServletContextListener {
    protected FileObject applicationRoot;
    protected Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(DispatcherInitializer.class);
    public static final String CODE_BASE_ATTRIBUTE = "portofino.codebase";

    public void contextInitialized(ServletContextEvent sce) {
        this.initialize(sce.getServletContext());
    }

    public void initialize(ServletContext servletContext) {
        String applicationDirectoryPath = this.getApplicationDirectoryPath(servletContext);
        if (applicationDirectoryPath != null) {
            try {
                this.applicationRoot = VFS.getManager().resolveFile(applicationDirectoryPath);
                if (this.applicationRoot.getType() != FileType.FOLDER) {
                    logger.error("Configured application directory " + applicationDirectoryPath + " is not a directory");
                    this.applicationRoot = null;
                }
            }
            catch (FileSystemException e) {
                logger.error("Configured application directory " + applicationDirectoryPath + " is not valid", (Throwable)e);
            }
        }
        if (this.applicationRoot == null) {
            try {
                this.applicationRoot = VFS.getManager().toFileObject(new File(servletContext.getRealPath(""), "WEB-INF"));
            }
            catch (FileSystemException e) {
                this.initializationFailed((Exception)((Object)e));
            }
        }
        logger.info("Application directory: {}", (Object)this.applicationRoot);
        try {
            this.loadConfiguration(servletContext, this.applicationRoot);
        }
        catch (Exception e) {
            this.initializationFailed(e);
        }
        String actionsDirectory = this.configuration.getString("portofino.actions.path", "actions");
        this.initApplicationRoot(servletContext, actionsDirectory);
        logger.info("Application initialized.");
    }

    protected String getApplicationDirectoryPath(ServletContext servletContext) {
        return servletContext.getInitParameter("portofino.application.directory");
    }

    protected void loadConfiguration(ServletContext servletContext, FileObject applicationRoot) throws FileSystemException, ConfigurationException {
        FileObject configurationFile = applicationRoot.getChild("portofino.properties");
        CombinedConfiguration compositeConfiguration = new CombinedConfiguration();
        if (configurationFile != null) {
            Configurations configurations = new Configurations();
            PropertiesConfiguration configuration = configurations.properties(configurationFile.getURL());
            FileObject localConfigurationFile = applicationRoot.getChild("portofino-local.properties");
            if (localConfigurationFile != null && localConfigurationFile.exists() && localConfigurationFile.getType() == FileType.FILE) {
                logger.info("Local configuration found: {}", (Object)localConfigurationFile);
                PropertiesConfiguration localConfiguration = configurations.properties(localConfigurationFile.getURL());
                compositeConfiguration.addConfiguration((Configuration)localConfiguration);
            }
            compositeConfiguration.addConfiguration((Configuration)configuration);
            this.configuration = compositeConfiguration;
        } else {
            this.configuration = new PropertiesConfiguration();
            logger.warn("portofino.properties file not found in " + applicationRoot);
        }
        servletContext.setAttribute("portofino.configuration", (Object)this.configuration);
    }

    protected void initApplicationRoot(ServletContext servletContext, String actionsDirectoryName) {
        try {
            FileObject actionsDirectory = this.applicationRoot.getChild(actionsDirectoryName);
            if (actionsDirectory == null || actionsDirectory.getType() != FileType.FOLDER) {
                this.initializationFailed(new Exception("Not a directory: " + actionsDirectoryName));
            }
            CodeBase codeBase = this.createAndStoreCodeBase(servletContext);
            ResourceResolvers resourceResolver = new ResourceResolvers();
            this.configureResourceResolvers(resourceResolver, codeBase);
            DocumentedApiRoot.setRootFactory(() -> this.getRoot(actionsDirectory, resourceResolver));
        }
        catch (Exception e) {
            this.initializationFailed(e);
        }
    }

    protected CodeBase createAndStoreCodeBase(ServletContext servletContext) throws IOException {
        JavaCodeBase javaCodeBase;
        FileObject codeBaseRoot = this.getCodeBaseRoot();
        JavaCodeBase codeBase = javaCodeBase = new JavaCodeBase(codeBaseRoot, null, this.getClass().getClassLoader());
        try {
            Class<?> gcb = Class.forName("com.manydesigns.portofino.code.GroovyCodeBase");
            Constructor<?> gcbConstructor = gcb.getConstructor(FileObject.class, CodeBase.class);
            codeBase = (CodeBase)gcbConstructor.newInstance(codeBaseRoot, javaCodeBase);
            logger.info("Groovy is available");
        }
        catch (Exception e) {
            logger.debug("Groovy not available", (Throwable)e);
        }
        servletContext.setAttribute(CODE_BASE_ATTRIBUTE, (Object)codeBase);
        return codeBase;
    }

    protected FileObject getCodeBaseRoot() throws FileSystemException {
        return VFS.getManager().resolveFile("res:");
    }

    protected void configureResourceResolvers(ResourceResolvers resourceResolver, CodeBase codeBase) {
        resourceResolver.resourceResolvers.add(new JavaResourceResolver(codeBase));
        this.addResourceResolver(resourceResolver, "com.manydesigns.portofino.dispatcher.resolvers.GroovyResourceResolver", codeBase, false);
        this.addResourceResolver(resourceResolver, "com.manydesigns.portofino.dispatcher.resolvers.JacksonResourceResolver", codeBase, true);
    }

    protected Resource getRoot(FileObject actionsDirectory, ResourceResolvers resourceResolver) throws Exception {
        return Root.get(actionsDirectory, resourceResolver);
    }

    protected void addResourceResolver(ResourceResolvers resourceResolver, String className, CodeBase codeBase, boolean caching) {
        try {
            ResourceResolver resolver;
            Class<?> resClass = Class.forName(className);
            try {
                Constructor<?> resClassConstructor = resClass.getConstructor(CodeBase.class);
                resolver = (ResourceResolver)resClassConstructor.newInstance(codeBase);
            }
            catch (Exception e) {
                logger.debug("Constructor from CodeBase not available", (Throwable)e);
                resolver = (ResourceResolver)resClass.newInstance();
            }
            if (caching) {
                resolver = new CachingResourceResolver(resolver);
            }
            resourceResolver.resourceResolvers.add(resolver);
        }
        catch (Exception e) {
            logger.debug(className + " not available", (Throwable)e);
        }
    }

    protected void initializationFailed(Exception e) {
        logger.error("Could not initialize application", (Throwable)e);
        throw new RuntimeException(e);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        logger.info("Application destroyed.");
    }
}

