/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.resolvers;

import com.manydesigns.portofino.dispatcher.ResourceResolver;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolvers
implements ResourceResolver {
    public static final String COPYRIGHT = "Copyright (c) 2005-2016, ManyDesigns srl";
    protected static final Logger logger = LoggerFactory.getLogger(ResourceResolvers.class);
    public final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>();

    @Override
    public boolean supports(Class<?> type) {
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            if (!resourceResolver.supports(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(String extension) {
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            if (!resourceResolver.supports(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T resolve(FileObject location, Class<T> type) {
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            try {
                T resource;
                if (!this.supports(resourceResolver, type, location) || (resource = resourceResolver.resolve(location, type)) == null) continue;
                return resource;
            }
            catch (Exception e) {
                logger.warn("Resource resolution failed (resolver: " + resourceResolver + ", resource: " + location + ")", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public <T> T resolve(FileObject location, String name, Class<T> type) throws Exception {
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            try {
                T resource;
                if (!this.supports(resourceResolver, type, location) || (resource = resourceResolver.resolve(location, name, type)) == null) continue;
                return resource;
            }
            catch (Exception e) {
                logger.warn("Resource resolution failed (resolver: " + resourceResolver + ", resource: " + location + ")", (Throwable)e);
            }
        }
        return null;
    }

    protected <T> boolean supports(ResourceResolver resourceResolver, Class<T> type, FileObject location) throws FileSystemException {
        return resourceResolver.supports(type) && (location.getType() == FileType.FOLDER || resourceResolver.supports(location.getName().getExtension()));
    }

    @Override
    public FileObject resolve(FileObject location) throws FileSystemException {
        return this.resolve(location, (String)null);
    }

    @Override
    public FileObject resolve(FileObject location, String name) throws FileSystemException {
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            try {
                FileObject resource = resourceResolver.resolve(location, name);
                if (resource == null) continue;
                return resource;
            }
            catch (FileSystemException e) {
                logger.warn("Resource resolution failed (resolver: " + resourceResolver + ", resource: " + location + ")", (Throwable)e);
            }
        }
        return null;
    }
}

