/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.security;

import com.manydesigns.portofino.dispatcher.security.OperationPermission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.Permission;

public class RolesPermission
implements Permission {
    protected final Collection<String> roles;

    public RolesPermission(Collection<String> roles) {
        this.roles = roles;
    }

    public boolean implies(Permission p) {
        if (p instanceof OperationPermission) {
            boolean allowed = false;
            for (String role : this.roles) {
                List<Permission> permissions = this.getPermissions(role, ((OperationPermission)p).getAllow());
                if (permissions != null) {
                    for (Permission permission : permissions) {
                        if (allowed |= permission.implies(((OperationPermission)p).getPermission())) break;
                    }
                }
                if ((permissions = this.getPermissions(role, ((OperationPermission)p).getDeny())) == null) continue;
                for (Permission permission : permissions) {
                    if (!permission.implies(((OperationPermission)p).getPermission())) continue;
                    return false;
                }
            }
            return allowed;
        }
        return false;
    }

    protected List<Permission> getPermissions(String role, Map<String, List<Permission>> permissionMap) {
        List<Permission> permissions = permissionMap.get(role);
        if (permissions == null) {
            permissions = permissionMap.get("*");
        }
        return permissions;
    }
}

