/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.security.jwt;

import com.manydesigns.portofino.dispatcher.security.RolesPermission;
import com.manydesigns.portofino.dispatcher.security.jwt.JSONWebToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import java.io.Serializable;
import java.security.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.configuration2.Configuration;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class JWTRealm
extends AuthorizingRealm {
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Set<String> roles = this.getRoles(principals);
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo(roles);
        simpleAuthorizationInfo.addObjectPermission((Permission)new RolesPermission(roles));
        return simpleAuthorizationInfo;
    }

    protected Set<String> getRoles(PrincipalCollection principals) {
        return this.getRoles(principals.getPrimaryPrincipal());
    }

    protected Set<String> getRoles(Object principal) {
        Object rolesList;
        HashSet<String> roles = new HashSet<String>();
        if (principal instanceof Map && (rolesList = ((Map)principal).get("roles")) instanceof Collection) {
            roles.addAll((Collection)rolesList);
        }
        return roles;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String secret = this.getSecret();
        SecretKeySpec key = new SecretKeySpec((byte[])Decoders.BASE64.decode((Object)secret), this.getSignatureAlgorithm().getJcaName());
        Jws jwt = Jwts.parser().setSigningKey((Key)key).parseClaimsJws((String)token.getPrincipal());
        Map<String, Serializable> principal = this.getPrincipal((Jws<Claims>)jwt);
        return new SimpleAuthenticationInfo(principal, (Object)((String)token.getCredentials()).toCharArray(), this.getName());
    }

    protected SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.HS512;
    }

    protected Map<String, Serializable> getPrincipal(Jws<Claims> jwt) {
        HashMap<String, Serializable> principal = new HashMap<String, Serializable>();
        principal.put("jwt", (Serializable)jwt.getBody());
        return principal;
    }

    protected Configuration getConfiguration() {
        return null;
    }

    protected String getSecret() {
        return this.getConfiguration().getString("jwt.secret");
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof JSONWebToken;
    }
}

