/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.DependencyListResult;
import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.jni.DependencyOptions;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.Result;
import java.nio.file.Path;
import java.util.function.Function;

public class DependencyCommand {
    private final HelmLib helmLib;
    private final Path path;

    public DependencyCommand(HelmLib helmLib, Path path) {
        this.helmLib = helmLib;
        this.path = path;
    }

    public DependencySubcommand<String> build() {
        return new DependencySubcommand<String>(this.helmLib, this.path, hl -> arg_0 -> ((HelmLib)hl).DependencyBuild(arg_0), r -> r.out);
    }

    public DependencySubcommand<DependencyListResult> list() {
        return new DependencySubcommand<DependencyListResult>(this.helmLib, this.path, hl -> arg_0 -> ((HelmLib)hl).DependencyList(arg_0), DependencyListResult::parse);
    }

    public DependencySubcommand<String> update() {
        return new DependencySubcommand<String>(this.helmLib, this.path, hl -> arg_0 -> ((HelmLib)hl).DependencyUpdate(arg_0), r -> r.out);
    }

    public static final class DependencySubcommand<T>
    extends HelmCommand<T> {
        private final Function<HelmLib, Function<DependencyOptions, Result>> callable;
        private final Function<Result, T> transformer;
        private final Path path;
        private Path keyring;
        private boolean skipRefresh;
        private boolean verify;
        private boolean debug;

        DependencySubcommand(HelmLib helmLib, Path path, Function<HelmLib, Function<DependencyOptions, Result>> callable, Function<Result, T> transformer) {
            super(helmLib);
            this.callable = callable;
            this.transformer = transformer;
            this.path = path;
        }

        @Override
        public T call() {
            return this.transformer.apply(this.run(hl -> this.callable.apply((HelmLib)hl).apply(new DependencyOptions(DependencySubcommand.toString(this.path), DependencySubcommand.toString(this.keyring), DependencySubcommand.toInt(this.skipRefresh), DependencySubcommand.toInt(this.verify), DependencySubcommand.toInt(this.debug)))));
        }

        public DependencySubcommand<T> withKeyring(Path keyring) {
            this.keyring = keyring;
            return this;
        }

        public DependencySubcommand<T> skipRefresh() {
            this.skipRefresh = true;
            return this;
        }

        public DependencySubcommand<T> verify() {
            this.verify = true;
            return this;
        }

        public DependencySubcommand<T> debug() {
            this.debug = true;
            return this;
        }
    }
}

