/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.CreateCommand;
import com.marcnuri.helm.DependencyCommand;
import com.marcnuri.helm.InstallCommand;
import com.marcnuri.helm.LintCommand;
import com.marcnuri.helm.ListCommand;
import com.marcnuri.helm.PackageCommand;
import com.marcnuri.helm.PushCommand;
import com.marcnuri.helm.RegistryCommand;
import com.marcnuri.helm.RepoCommand;
import com.marcnuri.helm.SearchCommand;
import com.marcnuri.helm.ShowCommand;
import com.marcnuri.helm.TestCommand;
import com.marcnuri.helm.UninstallCommand;
import com.marcnuri.helm.UpgradeCommand;
import com.marcnuri.helm.VersionCommand;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.NativeLibrary;
import java.nio.file.Path;

public class Helm {
    private final Path path;

    public Helm(Path path) {
        this.path = path;
    }

    public static CreateCommand create() {
        return new CreateCommand(HelmLibHolder.INSTANCE);
    }

    public DependencyCommand dependency() {
        return new DependencyCommand(HelmLibHolder.INSTANCE, this.path);
    }

    public static InstallCommand install(String chart) {
        return new InstallCommand(HelmLibHolder.INSTANCE).withChart(chart);
    }

    public InstallCommand install() {
        return new InstallCommand(HelmLibHolder.INSTANCE, this.path);
    }

    public LintCommand lint() {
        return new LintCommand(HelmLibHolder.INSTANCE, this.path);
    }

    public static ListCommand list() {
        return new ListCommand(HelmLibHolder.INSTANCE);
    }

    public PackageCommand packageIt() {
        return new PackageCommand(HelmLibHolder.INSTANCE, this, this.path);
    }

    public static PushCommand push() {
        return new PushCommand(HelmLibHolder.INSTANCE);
    }

    public static RegistryCommand registry() {
        return new RegistryCommand(HelmLibHolder.INSTANCE);
    }

    public static RepoCommand repo() {
        return new RepoCommand(HelmLibHolder.INSTANCE);
    }

    public static SearchCommand search() {
        return new SearchCommand(HelmLibHolder.INSTANCE);
    }

    public static ShowCommand show(String chart) {
        return new ShowCommand(HelmLibHolder.INSTANCE, chart);
    }

    public ShowCommand show() {
        return new ShowCommand(HelmLibHolder.INSTANCE, this.path);
    }

    public static TestCommand test(String releaseName) {
        return new TestCommand(HelmLibHolder.INSTANCE, releaseName);
    }

    public static UninstallCommand uninstall(String releaseName) {
        return new UninstallCommand(HelmLibHolder.INSTANCE, releaseName);
    }

    public static UpgradeCommand upgrade(String chart) {
        return new UpgradeCommand(HelmLibHolder.INSTANCE).withChart(chart);
    }

    public UpgradeCommand upgrade() {
        return new UpgradeCommand(HelmLibHolder.INSTANCE, this.path);
    }

    public static VersionCommand version() {
        return new VersionCommand(HelmLibHolder.INSTANCE);
    }

    static final class HelmLibHolder {
        static final HelmLib INSTANCE = NativeLibrary.getInstance().load();

        private HelmLibHolder() {
        }
    }
}

