/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.DryRun;
import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.Release;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.InstallOptions;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class InstallCommand
extends HelmCommand<Release> {
    private String name;
    private boolean generateName;
    private String nameTemplate;
    private String chart;
    private String namespace;
    private boolean createNamespace;
    private String description;
    private boolean devel;
    private boolean dependencyUpdate;
    private boolean disableOpenApiValidation;
    private boolean dryRun;
    private DryRun dryRunOption;
    private boolean wait;
    private final Map<String, String> values;
    private Path kubeConfig;
    private Path certFile;
    private Path keyFile;
    private Path caFile;
    private boolean insecureSkipTlsVerify;
    private boolean plainHttp;
    private Path keyring;
    private boolean debug;
    private boolean clientOnly;

    public InstallCommand(HelmLib helmLib) {
        this(helmLib, null);
    }

    public InstallCommand(HelmLib helmLib, Path chart) {
        super(helmLib);
        this.chart = InstallCommand.toString(chart);
        this.values = new LinkedHashMap<String, String>();
    }

    @Override
    public Release call() {
        return Release.parseSingle(this.run(hl -> hl.Install(new InstallOptions(this.name, InstallCommand.toInt(this.generateName), this.nameTemplate, this.chart, this.namespace, InstallCommand.toInt(this.createNamespace), this.description, InstallCommand.toInt(this.devel), InstallCommand.toInt(this.dependencyUpdate), InstallCommand.toInt(this.disableOpenApiValidation), InstallCommand.toInt(this.dryRun), this.dryRunOption == null ? null : this.dryRunOption.name().toLowerCase(Locale.ROOT), InstallCommand.toInt(this.wait), InstallCommand.urlEncode(this.values), InstallCommand.toString(this.kubeConfig), InstallCommand.toString(this.certFile), InstallCommand.toString(this.keyFile), InstallCommand.toString(this.caFile), InstallCommand.toInt(this.insecureSkipTlsVerify), InstallCommand.toInt(this.plainHttp), InstallCommand.toString(this.keyring), InstallCommand.toInt(this.debug), InstallCommand.toInt(this.clientOnly)))));
    }

    public InstallCommand withName(String name) {
        this.name = name;
        return this;
    }

    public InstallCommand generateName() {
        this.generateName = true;
        return this;
    }

    public InstallCommand withNameTemplate(String nameTemplate) {
        this.nameTemplate = nameTemplate;
        return this;
    }

    InstallCommand withChart(String chart) {
        this.chart = chart;
        return this;
    }

    public InstallCommand withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public InstallCommand createNamespace() {
        this.createNamespace = true;
        return this;
    }

    public InstallCommand withDescription(String description) {
        this.description = description;
        return this;
    }

    public InstallCommand devel() {
        this.devel = true;
        return this;
    }

    public InstallCommand dependencyUpdate() {
        this.dependencyUpdate = true;
        return this;
    }

    public InstallCommand disableOpenApiValidation() {
        this.disableOpenApiValidation = true;
        return this;
    }

    public InstallCommand dryRun() {
        this.dryRun = true;
        return this;
    }

    public InstallCommand withDryRunOption(DryRun dryRunOption) {
        this.dryRunOption = dryRunOption;
        return this;
    }

    public InstallCommand waitReady() {
        this.wait = true;
        return this;
    }

    public InstallCommand set(String key, Object value) {
        this.values.put(key, value == null ? "" : value.toString());
        return this;
    }

    public InstallCommand withKubeConfig(Path kubeConfig) {
        this.kubeConfig = kubeConfig;
        return this;
    }

    public InstallCommand withCertFile(Path certFile) {
        this.certFile = certFile;
        return this;
    }

    public InstallCommand withKeyFile(Path keyFile) {
        this.keyFile = keyFile;
        return this;
    }

    public InstallCommand withCaFile(Path caFile) {
        this.caFile = caFile;
        return this;
    }

    public InstallCommand insecureSkipTlsVerify() {
        this.insecureSkipTlsVerify = true;
        return this;
    }

    public InstallCommand plainHttp() {
        this.plainHttp = true;
        return this;
    }

    public InstallCommand withKeyring(Path keyring) {
        this.keyring = keyring;
        return this;
    }

    public InstallCommand debug() {
        this.debug = true;
        return this;
    }

    public InstallCommand clientOnly() {
        this.clientOnly = true;
        return this;
    }
}

